/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.dataeditor;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PluginDataEditorServlet
extends HttpServlet {
    private static final String PDE_WEB_RESOURCE = "com.atlassian.plugins.plugin-data-editor:pde-plugin";
    private static final String EDITOR_PAGE_TEMPLATES_COMPLETE_KEY = "com.atlassian.plugins.plugin-data-editor:editor-page-templates";
    private static final String EDITOR_PAGE_TEMPLATE_NAME = "com.atlassian.plugins.plugindataeditor.editorPage";
    private final LoginUriProvider loginUriProvider;
    private final PageBuilderService pageBuilderService;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final UserManager userManager;
    private final WebSudoManager webSudoManager;
    static final String JIRA_SERAPH_SECURITY_ORIGINAL_URL = "os_security_originalurl";
    static final String CONF_SERAPH_SECURITY_ORIGINAL_URL = "seraph_originalurl";

    public PluginDataEditorServlet(LoginUriProvider loginUriProvider, PageBuilderService pageBuilderService, SoyTemplateRenderer soyTemplateRenderer, UserManager userManager, WebSudoManager webSudoManager) {
        this.loginUriProvider = Objects.requireNonNull(loginUriProvider);
        this.pageBuilderService = Objects.requireNonNull(pageBuilderService);
        this.soyTemplateRenderer = Objects.requireNonNull(soyTemplateRenderer);
        this.userManager = Objects.requireNonNull(userManager);
        this.webSudoManager = Objects.requireNonNull(webSudoManager);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            if (!this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey(request))) {
                this.redirectToLogin(request, response);
                return;
            }
            response.setContentType("text/html");
            this.pageBuilderService.assembler().resources().requireWebResource(PDE_WEB_RESOURCE);
            this.soyTemplateRenderer.render((Appendable)response.getWriter(), EDITOR_PAGE_TEMPLATES_COMPLETE_KEY, EDITOR_PAGE_TEMPLATE_NAME, this.getTemplateContext());
        }
        catch (WebSudoSessionException wse) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private Map<String, Object> getTemplateContext() {
        return Collections.singletonMap("dummyDataKey", "com.atlassian.plugins.dataeditor:dummy.data");
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        URI uri = this.getUri(request);
        this.addSessionAttributes(request, uri.toASCIIString());
        response.sendRedirect(this.loginUriProvider.getLoginUri(uri).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void addSessionAttributes(HttpServletRequest request, String uriString) {
        request.getSession().setAttribute(JIRA_SERAPH_SECURITY_ORIGINAL_URL, (Object)uriString);
        request.getSession().setAttribute(CONF_SERAPH_SECURITY_ORIGINAL_URL, (Object)uriString);
    }
}

