/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.dataeditor;

import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.Objects;
import java.util.Optional;

public class DataManager
implements LifecycleAware {
    public static final String DUMMY_DATA_KEY = "com.atlassian.plugins.dataeditor:dummy.data";
    public static final String DUMMY_DATA_VALUE = "This is some dummy data.";
    private final PluginSettingsFactory pluginSettingsFactory;

    public DataManager(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = Objects.requireNonNull(pluginSettingsFactory);
    }

    public void onStart() {
        this.pluginSettingsFactory.createGlobalSettings().put(DUMMY_DATA_KEY, (Object)DUMMY_DATA_VALUE);
    }

    public void onStop() {
        this.pluginSettingsFactory.createGlobalSettings().remove(DUMMY_DATA_KEY);
    }

    public Optional<Object> getGlobalPluginSetting(String dataKey) {
        return Optional.ofNullable(this.pluginSettingsFactory.createGlobalSettings()).map(settings -> settings.get(dataKey));
    }

    public Optional<Object> getKeyedPluginSetting(String settingsKey, String dataKey) {
        return this.getSettingsForKey(settingsKey).map(settings -> settings.get(dataKey));
    }

    private Optional<PluginSettings> getSettingsForKey(String settingsKey) {
        try {
            return Optional.ofNullable(this.pluginSettingsFactory.createSettingsForKey(settingsKey));
        }
        catch (IllegalArgumentException noSuchKey) {
            return Optional.empty();
        }
    }
}

