/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock;

import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLock;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock.RestLfsLockOwner;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonSerialize
@JsonSurrogate(value=LfsLock.class)
public class RestLfsLock
extends RestMapEntity {
    private static final String ID = "id";
    private static final DateTimeFormatter ISO8601_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneOffset.UTC);
    private static final String LOCKED_AT = "locked_at";
    private static final String OWNER = "owner";
    private static final String PATH = "path";

    public RestLfsLock() {
    }

    public RestLfsLock(Map<String, Object> values) {
        super(values);
    }

    public RestLfsLock(@Nonnull LfsLock lock) {
        Objects.requireNonNull(lock, "lock");
        this.put(ID, Integer.toString(lock.getId()));
        this.put(LOCKED_AT, ISO8601_FORMATTER.format(lock.getLockedAt().toInstant()));
        this.put(OWNER, (Object)new RestLfsLockOwner(lock.getOwner()));
        this.put(PATH, lock.getPath());
    }

    public int getId() {
        return this.getIntProperty(ID);
    }

    @Nonnull
    public String getPath() {
        return this.getStringProperty(PATH);
    }

    public static RestLfsLock valueOf(Object value) {
        if (value instanceof RestLfsLock) {
            return (RestLfsLock)((Object)value);
        }
        if (value instanceof Map) {
            return new RestLfsLock((Map)value);
        }
        return null;
    }
}

