/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.migration;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.LfsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.migration.GitLfsSettingsMetadata;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.ImportException;
import com.atlassian.bitbucket.migration.Importer;
import com.atlassian.bitbucket.migration.StandardMigrationEntityType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitLfsSettingsImporter
implements Importer {
    private static final Logger log = LoggerFactory.getLogger(GitLfsSettingsImporter.class);
    private static final PathMatcher matchSettings = FileSystems.getDefault().getPathMatcher("glob:*/git-lfs-settings.json");
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final I18nService i18nService;
    private final LfsService lfsService;
    private final RepositoryService repositoryService;

    public GitLfsSettingsImporter(I18nService i18nService, LfsService lfsService, RepositoryService repositoryService) {
        this.i18nService = i18nService;
        this.lfsService = lfsService;
        this.repositoryService = repositoryService;
    }

    public void onEntry(@Nonnull ImportContext context, @Nonnull EntrySource entry) {
        Objects.requireNonNull(entry, "entry");
        Objects.requireNonNull(context, "context");
        Path path = entry.getPath();
        log.debug("Importing Git LFS settings from path: {}", (Object)path);
        if (matchSettings.matches(path)) {
            try {
                entry.read(inputStream -> {
                    GitLfsSettingsMetadata gitLfsSettings = GitLfsSettingsImporter.toGitLfsSettingsMetadata(inputStream);
                    Repository repository = this.resolveRepositoryOrFail(context, GitLfsSettingsImporter.resolveExportId(path));
                    this.setGitLfsForRepository(repository, gitLfsSettings.isEnabled());
                });
            }
            catch (IOException e) {
                throw new ImportException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.migration.import.failed", new Object[]{path}), (Throwable)e);
            }
        } else {
            context.addWarning(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.migration.import.unknown.entry", new Object[]{path}), null);
        }
    }

    private static String resolveExportId(Path path) {
        return path.getName(0).toString();
    }

    private static GitLfsSettingsMetadata toGitLfsSettingsMetadata(InputStream inputStream) throws IOException {
        return (GitLfsSettingsMetadata)OBJECT_MAPPER.readValue(inputStream, GitLfsSettingsMetadata.class);
    }

    private Repository resolveRepositoryOrFail(ImportContext context, String exportId) {
        return context.getEntityMapping(StandardMigrationEntityType.REPOSITORY).getLocalId(exportId).map(arg_0 -> ((RepositoryService)this.repositoryService).getById(arg_0)).orElseThrow(() -> new ImportException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.migration.import.repository.notfound", new Object[]{exportId})));
    }

    private void setGitLfsForRepository(Repository repository, boolean enabled) {
        if (enabled) {
            this.lfsService.enable(repository);
        } else {
            this.lfsService.disable(repository);
        }
    }
}

