/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest.model;

import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseAction;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

@JsonSerialize
public class RestResponseAction
extends RestMapEntity {
    private static final String HEADER_KEY = "header";
    private static final String HREF_KEY = "href";

    public RestResponseAction(@Nonnull ResponseAction responseAction) {
        this.put(HREF_KEY, responseAction.getHref());
        this.put(HEADER_KEY, responseAction.getHeaders());
    }

    protected RestResponseAction(@Nonnull Map<String, Object> values) {
        super(values);
    }

    @Nonnull
    public static RestResponseAction valueOf(@Nonnull Map<String, Object> values) {
        return new RestResponseAction(values);
    }

    @Nonnull
    public Map<String, String> getHeader() {
        Map<String, String> value = (Map<String, String>)this.get(HEADER_KEY);
        return value != null ? value : Collections.emptyMap();
    }

    @Nonnull
    public Optional<String> getHref() {
        return Optional.ofNullable(this.getStringProperty(HREF_KEY));
    }
}

