/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.dao;

import com.atlassian.bitbucket.internal.scm.git.lfs.dao.AoLfsLock;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class PartialLfsLock {
    private final AoLfsLock delegate;
    private ApplicationUser owner;
    private Repository repository;

    public PartialLfsLock(@Nonnull AoLfsLock delegate) {
        this.delegate = delegate;
    }

    @Nonnull
    public ApplicationUser getOwner() {
        return Optional.ofNullable(this.owner).orElseThrow(this::throwNotInitialised);
    }

    @Nonnull
    public Repository getRepository() {
        return Optional.ofNullable(this.repository).orElseThrow(this::throwNotInitialised);
    }

    public void initialise(@Nonnull ApplicationUser owner, @Nonnull Repository repository) {
        this.owner = Objects.requireNonNull(owner, "owner");
        this.repository = Objects.requireNonNull(repository, "repository");
    }

    private IllegalStateException throwNotInitialised() {
        throw new IllegalStateException(String.format("AoLfsLock %d not yet initialised", this.delegate.getId()));
    }
}

