/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.store;

import com.atlassian.bitbucket.dmz.filestore.FileStoreService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.EmbeddedStoreService;
import com.atlassian.bitbucket.internal.scm.git.lfs.jwt.GitLfsJwtHelper;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.DefaultUpstreamLfsClient;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.store.DefaultStoreAccessor;
import com.atlassian.bitbucket.internal.scm.git.lfs.store.FileStoreAccessor;
import com.atlassian.bitbucket.internal.scm.git.lfs.store.MirrorStoreAccessor;
import com.atlassian.bitbucket.internal.scm.git.lfs.store.StoreAccessor;
import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.SecurityService;
import java.util.concurrent.ExecutorService;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class StoreAccessorFactoryBean
extends AbstractFactoryBean<StoreAccessor>
implements DisposableBean {
    private final BundleContext context;
    private final EmbeddedStoreService embeddedStoreService;
    private final ExecutorService executorService;
    private final FileStoreService fileStoreService;
    private final I18nService i18nService;
    private final JsonRenderer jsonRenderer;
    private final GitLfsJwtHelper jwtHelper;
    private final NavBuilder navBuilder;
    private final ApplicationPropertiesService propertiesService;
    private final RepositoryService repositoryService;
    private final RequestManager requestManager;
    private final SecurityService securityService;
    private final GitLfsSettingsService settingsService;

    public StoreAccessorFactoryBean(BundleContext context, EmbeddedStoreService embeddedStoreService, ExecutorService executorService, FileStoreService fileStoreService, I18nService i18nService, JsonRenderer jsonRenderer, GitLfsJwtHelper jwtHelper, NavBuilder navBuilder, ApplicationPropertiesService propertiesService, RepositoryService repositoryService, RequestManager requestManager, SecurityService securityService, GitLfsSettingsService settingsService) {
        this.context = context;
        this.embeddedStoreService = embeddedStoreService;
        this.executorService = executorService;
        this.fileStoreService = fileStoreService;
        this.i18nService = i18nService;
        this.jsonRenderer = jsonRenderer;
        this.jwtHelper = jwtHelper;
        this.navBuilder = navBuilder;
        this.propertiesService = propertiesService;
        this.repositoryService = repositoryService;
        this.requestManager = requestManager;
        this.securityService = securityService;
        this.settingsService = settingsService;
    }

    public Class<?> getObjectType() {
        return StoreAccessor.class;
    }

    protected StoreAccessor createInstance() {
        if (this.propertiesService.getMode() == ApplicationMode.MIRROR) {
            return new MirrorStoreAccessor(this.embeddedStoreService, this.i18nService, this.jwtHelper, this.navBuilder, this.settingsService, new DefaultUpstreamLfsClient(this.i18nService, this.jsonRenderer, this.context, this.requestManager));
        }
        if (!this.fileStoreService.isDefaultStore()) {
            return new FileStoreAccessor(this.executorService, this.fileStoreService, this.i18nService, this.repositoryService, this.securityService, this.settingsService);
        }
        return new DefaultStoreAccessor(this.embeddedStoreService, this.executorService, this.i18nService, this.jwtHelper, this.navBuilder, this.repositoryService, this.securityService, this.settingsService);
    }

    protected void destroyInstance(StoreAccessor instance) throws Exception {
        if (instance instanceof MirrorStoreAccessor) {
            ((MirrorStoreAccessor)instance).destroy();
        }
    }
}

