/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest.model;

import com.atlassian.bitbucket.internal.scm.git.lfs.BadBatchResponseException;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchResponse;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.ResponseObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.model.RestResponseObject;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonSerialize
public class RestBatchResponse
extends RestMapEntity {
    private static final String OBJECTS_KEY = "objects";

    public RestBatchResponse() {
    }

    public RestBatchResponse(@Nonnull BatchResponse batchResponse) {
        this.put(OBJECTS_KEY, RestBatchResponse.transform(batchResponse.getObjects(), RestResponseObject::new));
    }

    public RestBatchResponse(@Nonnull Map<String, Object> values) {
        super(values);
    }

    @Nonnull
    public BatchResponse fromRest() {
        return new BatchResponse(this.getObjects());
    }

    private List<ResponseObject> getObjects() {
        List objects = (List)this.get(OBJECTS_KEY);
        if (objects == null) {
            throw new BadBatchResponseException("Response is missing required 'objects' attribute");
        }
        return (List)objects.stream().map(object -> RestResponseObject.valueOf(object).fromRest()).filter(Objects::nonNull).collect(MoreCollectors.toImmutableList());
    }
}

