/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.LfsHttpScmUtils;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseLfsHttpScmRequest
implements HttpScmRequest {
    private static final ObjectMapper OBJECT_MAPPER = BaseLfsHttpScmRequest.createMapper();
    protected final AuthenticationContext authenticationContext;
    protected final I18nService i18nService;
    protected final Repository repository;
    protected final HttpServletRequest request;
    protected final HttpServletResponse response;

    public BaseLfsHttpScmRequest(@Nonnull AuthenticationContext authenticationContext, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull I18nService i18nService, @Nonnull Repository repository) {
        this.authenticationContext = Objects.requireNonNull(authenticationContext, "authenticationContext");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.repository = Objects.requireNonNull(repository, "repository");
        this.request = Objects.requireNonNull(request, "request");
        this.response = Objects.requireNonNull(response, "response");
    }

    protected static ObjectMapper createMapper() {
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    protected static <T> T deserialize(InputStream in, Class<T> t) throws IOException {
        return (T)OBJECT_MAPPER.readValue(in, t);
    }

    protected static void serialize(OutputStream out, Object value) throws IOException {
        OBJECT_MAPPER.writeValue(out, value);
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public boolean isAsyncSupported() {
        return true;
    }

    public boolean isWrite() {
        return false;
    }

    public void sendError(@Nonnull String summary, @Nonnull String detailMessage) throws IOException {
        LfsHttpScmUtils.sendError(this.response, 422, summary + "\n\n" + detailMessage);
    }
}

