/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.dao;

import com.atlassian.bitbucket.internal.scm.git.lfs.dao.PartialLfsLock;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLock;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import java.util.Date;
import javax.annotation.Nonnull;
import net.java.ao.Accessor;
import net.java.ao.Implementation;
import net.java.ao.Preload;
import net.java.ao.RawEntity;
import net.java.ao.schema.AutoIncrement;
import net.java.ao.schema.Ignore;
import net.java.ao.schema.Index;
import net.java.ao.schema.Indexes;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.PrimaryKey;
import net.java.ao.schema.StringLength;
import net.java.ao.schema.Table;
import net.java.ao.schema.Unique;

@Preload
@Table(value="GIT_LFS_LOCK")
@Implementation(value=PartialLfsLock.class)
@Indexes(value={@Index(name="repo", methodNames={"getRepositoryId"}), @Index(name="directoryHash", methodNames={"getDirectoryHash"})})
public interface AoLfsLock
extends RawEntity<Integer>,
LfsLock {
    public static final String DIRECTORY_HASH_COLUMN = "DIRECTORY_HASH";
    public static final String ID_COLUMN = "ID";
    public static final String LOCKED_AT_COLUMN = "LOCKED_AT";
    public static final String OWNER_ID_COLUMN = "OWNER_ID";
    public static final String PATH_COLUMN = "PATH";
    public static final String REPOSITORY_ID_COLUMN = "REPOSITORY_ID";
    public static final String REPOSITORY_PATH_HASH_COLUMN = "REPO_PATH_HASH";
    public static final String TABLE_NAME = "GIT_LFS_LOCK";

    @Override
    @Accessor(value="DIRECTORY_HASH")
    @NotNull
    @StringLength(value=64)
    public String getDirectoryHash();

    @Override
    @AutoIncrement
    @NotNull
    @PrimaryKey(value="ID")
    public Integer getId();

    @Override
    @Accessor(value="LOCKED_AT")
    @NotNull
    public Date getLockedAt();

    @Override
    @Ignore
    @NotNull
    public ApplicationUser getOwner();

    @Accessor(value="OWNER_ID")
    @NotNull
    public Integer getOwnerId();

    @Override
    @Accessor(value="PATH")
    @NotNull
    @StringLength(value=-1)
    public String getPath();

    @Override
    @Ignore
    @NotNull
    public Repository getRepository();

    @Accessor(value="REPOSITORY_ID")
    @NotNull
    public Integer getRepositoryId();

    @Accessor(value="REPO_PATH_HASH")
    @NotNull
    @StringLength(value=75)
    @Unique
    public String getRepositoryPathHash();

    @Ignore
    public void initialise(@Nonnull ApplicationUser var1, @Nonnull Repository var2);
}

