/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest.storage;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.EmbeddedStoreService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ObjectByteRange;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ObjectStreamingOutput;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ReadObjectRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.http.mime.HostileExtensionDetector;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import java.io.InputStream;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
@Path(value="/storage")
@Singleton
public class GitLfsStorageResource {
    private static final String OID_URI = "/{projectKey}/{repositorySlug}/{oid}";
    private static final Logger log = LoggerFactory.getLogger(GitLfsStorageResource.class);
    private final HostileExtensionDetector hostileExtensionDetector;
    private final I18nService i18nService;
    private final RepositoryService repositoryService;
    private final EmbeddedStoreService storeService;

    @Inject
    public GitLfsStorageResource(EmbeddedStoreService storeService, HostileExtensionDetector hostileExtensionDetector, I18nService i18nService, RepositoryService repositoryService) {
        this.storeService = storeService;
        this.hostileExtensionDetector = hostileExtensionDetector;
        this.i18nService = i18nService;
        this.repositoryService = repositoryService;
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="/{projectKey}/{repositorySlug}/{oid}")
    public Response getObject(@PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repositorySlug, @PathParam(value="oid") String oid, @HeaderParam(value="Range") String rangeHeader, @QueryParam(value="response-content-disposition") String responseContentDisposition, @QueryParam(value="response-content-type") String responseContentType) {
        Repository repository = this.repositoryService.getBySlug(projectKey, repositorySlug);
        if (repository == null) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.rest.service.accessdenied", new Object[0]));
        }
        Optional<ObjectByteRange> parsedRange = ObjectByteRange.parseRange(rangeHeader);
        if (rangeHeader != null && !parsedRange.isPresent()) {
            log.debug("HTTP range format invalid or unsupported");
        }
        ObjectStreamingOutput stream = this.storeService.readObject(new ReadObjectRequest.Builder(repository, oid).range(parsedRange.orElse(null)).build());
        Response.ResponseBuilder builder = stream.range().map(streamRange -> ResponseFactory.status((int)206).entity((Object)stream).header("Content-Range", (Object)String.format("bytes %s/*", streamRange))).orElse(ResponseFactory.ok().entity((Object)stream));
        if (StringUtils.isNotEmpty((CharSequence)responseContentDisposition)) {
            builder.header("Content-Disposition", (Object)GitLfsStorageResource.replaceNonAscii(responseContentDisposition));
        }
        if (StringUtils.isNotEmpty((CharSequence)responseContentType) && !this.hostileExtensionDetector.isExecutableContentType(responseContentType)) {
            builder.header("Content-Type", (Object)responseContentType);
        }
        return builder.build();
    }

    @PUT
    @Produces(value={"application/vnd.git-lfs+json; charset=utf-8"})
    @Path(value="/{projectKey}/{repositorySlug}/{oid}")
    public Response putObject(@BeanParam RepositoryResolver repositoryResolver, @PathParam(value="oid") String oid, InputStream is) {
        this.storeService.writeObject(repositoryResolver.getRepository(), oid, is);
        return ResponseFactory.ok().build();
    }

    private static String replaceNonAscii(String value) {
        return value.replaceAll("[^\\p{ASCII}]", "_");
    }
}

