/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.settings;

import com.atlassian.bitbucket.dmz.mirror.DmzSecretService;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.DefaultJwtSecretProvider;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.JwtSecretProvider;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.MirrorJwtSecretProvider;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class JwtSecretProviderFactory
extends AbstractFactoryBean<JwtSecretProvider> {
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ApplicationPropertiesService propertiesService;
    private final ServiceTracker<DmzSecretService, DmzSecretService> secretService;
    private final TransactionTemplate transactionTemplate;

    public JwtSecretProviderFactory(ApplicationPropertiesService propertiesService, BundleContext bundleContext, PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate) {
        this.propertiesService = propertiesService;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.transactionTemplate = transactionTemplate;
        this.secretService = new ServiceTracker(bundleContext, DmzSecretService.class, null);
        this.secretService.open();
    }

    public void destroy() throws Exception {
        this.secretService.close();
        super.destroy();
    }

    public Class<?> getObjectType() {
        return JwtSecretProvider.class;
    }

    protected JwtSecretProvider createInstance() throws Exception {
        DefaultJwtSecretProvider provider = this.propertiesService.getMode() == ApplicationMode.MIRROR ? new MirrorJwtSecretProvider((DmzSecretService)Objects.requireNonNull(this.secretService.getService(), "secretService"), this.pluginSettingsFactory, this.transactionTemplate) : new DefaultJwtSecretProvider(this.pluginSettingsFactory, this.transactionTemplate);
        return provider;
    }
}

