/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.rest;

import com.atlassian.bitbucket.internal.scm.git.lfs.LfsService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/admin")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class GitLfsAdminResource {
    private final LfsService lfsService;

    public GitLfsAdminResource(LfsService lfsService) {
        this.lfsService = lfsService;
    }

    @DELETE
    @Path(value="/enabled")
    public Response disableLfs() {
        this.lfsService.disable();
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/enabled")
    public Response disableLfs(@Context Repository repository) {
        this.lfsService.disable(repository);
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="/enabled")
    public Response enableLfs() {
        this.lfsService.enable();
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/enabled")
    public Response enableLfs(@Context Repository repository) {
        this.lfsService.enable(repository);
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="/enabled")
    public Response getEnabled() {
        if (this.lfsService.isEnabled()) {
            return ResponseFactory.ok().build();
        }
        return ResponseFactory.notFound().build();
    }

    @GET
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/enabled")
    public Response getEnabled(@Context Repository repository) {
        if (this.lfsService.isEnabled(repository)) {
            return ResponseFactory.ok().build();
        }
        return ResponseFactory.notFound().build();
    }
}

