/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.protocol;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public enum GitScmRequestType {
    ARCHIVE("archive"),
    CAPABILITIES("capabilities"),
    CLONE("clone"),
    EMPTY(new String[0]),
    FETCH("fetch"),
    NEGOTIATION("shallow", "negotiation"),
    PUSH("push"),
    REFS("refs"),
    SHALLOW_CLONE("shallow", "clone"),
    SHALLOW_FETCH("shallow", "fetch"),
    UNKNOWN(new String[0]);

    private final ImmutableList<String> labels;
    private final boolean clone;
    private final boolean fetch;

    private GitScmRequestType(String ... labels) {
        this.labels = ImmutableList.copyOf((Object[])labels);
        this.clone = this.labels.contains((Object)"clone");
        this.fetch = this.labels.contains((Object)"fetch");
    }

    public boolean isClone() {
        return this.clone;
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public String toString() {
        return StringUtils.join(this.labels, (String)" ");
    }

    @Nonnull
    public ImmutableList<String> getLabels() {
        return this.labels;
    }
}

