/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.protocol;

import com.atlassian.bitbucket.scm.git.protocol.GitPacketListener;
import com.atlassian.bitbucket.scm.git.protocol.GitPackets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitPacketStream {
    private static final Logger log = LoggerFactory.getLogger(GitPacketStream.class);
    private static final byte[][] MARKER_PACKETS = new byte[][]{GitPackets.getFlush(), GitPackets.getDelim()};
    private static final int PACKET_PREFIX_SIZE = 4;
    private static final String PACK_HEADER = "PACK";
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
    private final List<GitPacketListener> listeners = Lists.newArrayList();
    private boolean abort;
    private boolean firstBuffer = true;
    private boolean inPackSection;
    private boolean inPrefix = true;
    private int nextPacketSize = 4;

    public void abort() {
        this.abort = true;
        byte[] inBuffer = this.buffer.toByteArray();
        this.buffer.reset();
        this.notifyListenersOfNonPacket(inBuffer, 0, inBuffer.length);
    }

    public void addListener(@Nonnull GitPacketListener listener) {
        this.listeners.add(Objects.requireNonNull(listener, "listener"));
    }

    public void append(@Nonnull byte[] bytes) {
        this.append(bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(@Nonnull byte[] bytes, int off, int len) {
        Objects.requireNonNull(bytes, "bytes");
        Preconditions.checkArgument((off >= 0 ? 1 : 0) != 0, (Object)"illegal offset");
        Preconditions.checkArgument((bytes.length >= off + len ? 1 : 0) != 0, (Object)"insufficient bytes");
        if (this.firstBuffer) {
            this.firstBuffer = false;
            if (len >= 2 && GitPacketStream.isGzipped(bytes)) {
                this.abort = true;
            }
        }
        int offset = off;
        int end = off + len;
        try {
            while (!this.abort && offset < end && this.nextPacketSize - this.buffer.size() <= end - offset) {
                if (this.buffer.size() > 0) {
                    int remainingPacketBytes = this.nextPacketSize - this.buffer.size();
                    this.buffer.write(bytes, offset, remainingPacketBytes);
                    offset += remainingPacketBytes;
                    if (this.inPrefix) {
                        this.readPacketPrefix(this.buffer.toByteArray(), 0);
                        if (this.abort) {
                            return;
                        }
                        if (this.nextPacketSize > 1) continue;
                        this.readPacket(MARKER_PACKETS[this.nextPacketSize]);
                        this.nextPacketSize = 4;
                        this.buffer.reset();
                        this.inPrefix = true;
                        continue;
                    }
                    this.readPacket(this.buffer.toByteArray());
                    this.buffer.reset();
                    continue;
                }
                if (this.inPrefix) {
                    this.readPacketPrefix(bytes, offset);
                    if (this.abort) {
                        return;
                    }
                    if (this.nextPacketSize > 1) continue;
                    offset += this.readPacket(MARKER_PACKETS[this.nextPacketSize]);
                    this.nextPacketSize = 4;
                    this.inPrefix = true;
                    continue;
                }
                byte[] packet = new byte[this.nextPacketSize];
                System.arraycopy(bytes, offset, packet, 0, this.nextPacketSize);
                offset += this.readPacket(packet);
            }
            if (!this.abort && offset < end) {
                this.buffer.write(bytes, offset, end - offset);
                offset = end;
            }
        }
        finally {
            if (offset != end) {
                this.abort = true;
            }
            if (this.abort && this.buffer.size() > 0) {
                byte[] data = this.buffer.toByteArray();
                this.notifyListenersOfNonPacket(data, 0, data.length);
                this.buffer.reset();
            }
            if (offset != end) {
                this.notifyListenersOfNonPacket(bytes, offset, end - offset);
            }
        }
    }

    public boolean isAborted() {
        return this.abort;
    }

    public boolean isInPackSection() {
        return this.inPackSection;
    }

    private static boolean isGzipped(byte[] bytes) {
        int second = bytes[1] & 0xFF;
        int first = bytes[0] & 0xFF;
        int magic = second << 8 | first;
        return magic == 35615;
    }

    private void notifyListeners(byte[] packet) {
        for (GitPacketListener listener : this.listeners) {
            try {
                listener.onPacket(packet);
            }
            catch (Exception e) {
                log.warn("Error while notifying {} of git packet", (Object)listener.getClass().getName(), (Object)e);
            }
        }
    }

    private void notifyListenersOfNonPacket(byte[] bytes, int off, int len) {
        for (GitPacketListener listener : this.listeners) {
            try {
                listener.onNonPacket(bytes, off, len);
            }
            catch (Exception e) {
                log.warn("Error while notifying {} of non-packet data", (Object)listener.getClass().getName(), (Object)e);
            }
        }
    }

    private int parsePacketSize(byte[] bytes, int offset) {
        String prefix = new String(bytes, offset, 4);
        if (!this.inPackSection && PACK_HEADER.equals(prefix)) {
            this.inPackSection = true;
            this.abort = true;
            return -1;
        }
        try {
            return Integer.parseInt(prefix, 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("'" + prefix + "' is not a valid git packet prefix");
        }
    }

    private int readPacket(byte[] packet) {
        this.notifyListeners(packet);
        this.nextPacketSize = 4;
        this.inPrefix = true;
        if (!this.inPackSection && packet.length > 8) {
            this.inPackSection = packet[4] == 1 && packet[5] == 80 && packet[6] == 65 && packet[7] == 67 && packet[8] == 75;
        }
        return packet.length;
    }

    private void readPacketPrefix(byte[] bytes, int offset) {
        this.nextPacketSize = this.parsePacketSize(bytes, offset);
        this.inPrefix = false;
    }
}

