/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.command;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.SimpleCommit;
import com.atlassian.bitbucket.commit.SimpleMinimalCommit;
import com.atlassian.bitbucket.io.LineReader;
import com.atlassian.bitbucket.scm.git.command.CommitReaderSettings;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.SimplePerson;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class CommitReader {
    private static final String BASE_FORMAT = "%H|%P|%aN|%aE|%at|%cN|%cE|%ct".replace("|", "%x02");
    private static final int EXPECTED_TOKENS = 8;
    private static final String MESSAGE_FORMAT = BASE_FORMAT + "%n{0}%n%x03END%x04";
    private static final String OBJECT_END = "\u0003END\u0004";
    private static final Pattern PARENT_SEPARATORS = Pattern.compile("\\s");
    private static final char SEPARATOR_CHAR = '\u0002';
    private static final String UNSPECIFIED_NAME = "Unspecified";
    private final CommitReaderSettings settings;

    public CommitReader(@Nonnull CommitReaderSettings settings) {
        this.settings = settings;
    }

    @Nonnull
    public String getFormat() {
        return this.settings.getMessageMode().getPlaceholder().map(placeholder -> MessageFormat.format(MESSAGE_FORMAT, placeholder)).orElse(BASE_FORMAT);
    }

    @Nullable
    public Commit readCommit(LineReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        if (!line.startsWith("commit")) {
            throw new IllegalStateException("[" + line + "]: Unexpected output; expected a 'commit' object");
        }
        line = reader.readLine();
        if (line == null) {
            throw new IllegalStateException("Unexpected end of output; no commit details were present");
        }
        String[] pieces = StringUtils.splitPreserveAllTokens((String)line, (char)'\u0002');
        if (pieces.length == 8) {
            SimpleCommit.Builder builder = new SimpleCommit.Builder(pieces[0]).author(CommitReader.parsePerson(pieces[2], pieces[3])).authorTimestamp(CommitReader.parseTimestamp(pieces[4])).committer(CommitReader.parsePerson(pieces[5], pieces[6])).committerTimestamp(CommitReader.parseTimestamp(pieces[7])).repository(this.settings.getRepository());
            String rawFullHashes = pieces[1];
            if (StringUtils.isNotBlank((CharSequence)rawFullHashes)) {
                for (String fullHash : PARENT_SEPARATORS.split(rawFullHashes)) {
                    builder.parent((MinimalCommit)new SimpleMinimalCommit.Builder(fullHash).build());
                }
            }
            if (this.settings.isWithMessages()) {
                builder.message(this.readMessage(reader));
            }
            return builder.build();
        }
        throw new IllegalStateException("[" + line + "]: Found " + pieces.length + " tokens where " + 8 + " were expected");
    }

    private static Person parsePerson(String name, String email) {
        if (StringUtils.isBlank((CharSequence)name)) {
            name = UNSPECIFIED_NAME;
            email = null;
        }
        return new SimplePerson(name, email);
    }

    private static Date parseTimestamp(String timestamp) {
        if (StringUtils.isBlank((CharSequence)timestamp)) {
            timestamp = "0";
        }
        return new Date(TimeUnit.SECONDS.toMillis(Long.parseLong(timestamp)));
    }

    private String readMessage(LineReader reader) throws IOException {
        StringBuilder message = new StringBuilder();
        int remaining = this.settings.getMaxMessageLength();
        boolean isUnlimited = this.settings.isMessageLengthUnlimited();
        while (true) {
            String line;
            String string = line = isUnlimited ? reader.readLine() : reader.readLine(Math.max(remaining, OBJECT_END.length() + 2));
            if (line == null || line.equals(OBJECT_END)) break;
            if (!isUnlimited && remaining <= 0) continue;
            if (message.length() > 0) {
                message.append("\n");
                --remaining;
            }
            int length = line.length();
            if (isUnlimited || length <= remaining) {
                message.append(line);
                remaining -= length;
                continue;
            }
            message.append(line, 0, remaining);
            remaining = 0;
        }
        String unchompedMessage = message.toString();
        String chompedMessage = StringUtils.chomp((String)message.toString());
        while (!chompedMessage.equals(unchompedMessage)) {
            unchompedMessage = chompedMessage;
            chompedMessage = StringUtils.chomp((String)unchompedMessage);
        }
        return chompedMessage;
    }
}

