/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.mesh;

import javax.annotation.Nonnull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ReplicaState {
    CONSISTENT(0){

        @Override
        public boolean isConsistent() {
            return true;
        }
    }
    ,
    INCONSISTENT(1),
    MISSING(2),
    REPAIRING(3),
    UNKNOWN(4);

    private final int id;

    private ReplicaState(int id) {
        this.id = id;
    }

    @Nonnull
    public static ReplicaState fromId(int id) {
        for (ReplicaState value : ReplicaState.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        throw new IllegalArgumentException("No ReplicaState is associated with ID [" + id + "]");
    }

    public int getId() {
        return this.id;
    }

    public boolean isConsistent() {
        return false;
    }
}

