/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.deployments;

import com.atlassian.bitbucket.dmz.deployments.DeploymentEnvironmentType;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class DeploymentEnvironmentSetRequest {
    private final String displayName;
    private final String key;
    private final DeploymentEnvironmentType type;
    private final URI url;

    private DeploymentEnvironmentSetRequest(Builder builder) {
        this.displayName = builder.displayName;
        this.key = builder.key;
        this.type = builder.type;
        this.url = builder.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentEnvironmentSetRequest that = (DeploymentEnvironmentSetRequest)o;
        return this.key.equals(that.key) && this.type == that.type && this.displayName.equals(that.displayName);
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public Optional<DeploymentEnvironmentType> getType() {
        return Optional.ofNullable(this.type);
    }

    @Nonnull
    public Optional<URI> getUrl() {
        return Optional.ofNullable(this.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.displayName, this.type});
    }

    public static class Builder
    extends BuilderSupport {
        private final String displayName;
        private final String key;
        private DeploymentEnvironmentType type;
        private URI url;

        public Builder(@Nonnull String displayName, @Nonnull String key) {
            this.displayName = Builder.requireNonBlank((String)displayName, (String)"name");
            this.key = Builder.requireNonBlank((String)key, (String)"id");
        }

        @Nonnull
        public DeploymentEnvironmentSetRequest build() {
            return new DeploymentEnvironmentSetRequest(this);
        }

        @Nonnull
        public Builder type(@Nullable DeploymentEnvironmentType value) {
            this.type = value;
            return this;
        }

        @Nonnull
        public Builder url(@Nullable URI value) {
            this.url = value;
            return this;
        }
    }
}

