/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.mesh;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MeshRepositoryConsistencySummary {
    private final Set<Long> consistentReplicas;
    private final Set<Long> inconsistentReplicas;
    private final String repositoryId;
    private final Instant startTimestamp;
    private final Set<Long> unavailableReplicas;
    private final long version;

    private MeshRepositoryConsistencySummary(Builder builder) {
        this.consistentReplicas = builder.consistentReplicas.build();
        this.inconsistentReplicas = builder.inconsistentReplicas.build();
        this.repositoryId = builder.repositoryId;
        this.startTimestamp = builder.startTimestamp;
        this.unavailableReplicas = builder.unavailableReplicas.build();
        this.version = builder.version;
    }

    @Nonnull
    public Set<Long> getConsistentReplicas() {
        return this.consistentReplicas;
    }

    @Nonnull
    public Set<Long> getInconsistentReplicas() {
        return this.inconsistentReplicas;
    }

    @Nonnull
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Nullable
    public Instant getStartTimestamp() {
        return this.startTimestamp;
    }

    @Nonnull
    public Set<Long> getUnavailableReplicas() {
        return this.unavailableReplicas;
    }

    public long getVersion() {
        return this.version;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<Long> consistentReplicas;
        private final ImmutableSet.Builder<Long> inconsistentReplicas;
        private final String repositoryId;
        private final ImmutableSet.Builder<Long> unavailableReplicas;
        private final long version;
        private Instant startTimestamp;

        public Builder(@Nonnull String repositoryId, long version) {
            this.repositoryId = Builder.requireNonBlank((String)repositoryId, (String)"repositoryId");
            this.version = version;
            this.consistentReplicas = ImmutableSet.builder();
            this.inconsistentReplicas = ImmutableSet.builder();
            this.unavailableReplicas = ImmutableSet.builder();
        }

        @Nonnull
        public MeshRepositoryConsistencySummary build() {
            return new MeshRepositoryConsistencySummary(this);
        }

        @Nonnull
        public Builder consistentReplicas(@Nullable Iterable<Long> values) {
            Builder.addIf(Objects::nonNull, this.consistentReplicas, values);
            return this;
        }

        @Nonnull
        public Builder inconsistentReplicas(@Nullable Iterable<Long> values) {
            Builder.addIf(Objects::nonNull, this.inconsistentReplicas, values);
            return this;
        }

        @Nonnull
        public Builder startTimestamp(@Nullable Instant value) {
            this.startTimestamp = value;
            return this;
        }

        @Nonnull
        public Builder unavailableReplicas(@Nullable Iterable<Long> values) {
            Builder.addIf(Objects::nonNull, this.unavailableReplicas, values);
            return this;
        }
    }
}

