/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.signature.verification;

public enum SignatureState {
    GOOD('G', true),
    BAD('B', false),
    GOOD_BUT_UNKNOWN_VALIDITY('U', false),
    GOOD_BUT_OUT_OF_DATE('X', true),
    GOOD_BUT_MADE_AFTER_EXPIRY('Y', false),
    GOOD_BUT_MADE_BEFORE_VALIDITY('Z', false),
    GOOD_BUT_REVOKED('T', false),
    ERROR('E', false),
    SIGNATURE_NOT_FOUND('N', false),
    PUBLIC_KEY_NOT_FOUND('K', false);

    private final char code;
    private final boolean isVerified;

    private SignatureState(char code, boolean isVerified) {
        this.code = code;
        this.isVerified = isVerified;
    }

    public static SignatureState fromCode(char code) {
        for (SignatureState value : SignatureState.values()) {
            if (code != value.code) continue;
            return value;
        }
        throw new IllegalArgumentException("code '" + code + "' is not valid");
    }

    public char getCode() {
        return this.code;
    }

    public boolean isVerified() {
        return this.isVerified;
    }
}

