/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.user;

import com.atlassian.bitbucket.dmz.user.PermittedUserGlobalSearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedUserProjectSearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedUserRepositorySearchRequest;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.UserType;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class PermittedUserSearchRequest {
    private final UserType userType;
    private final String nameFilter;

    protected PermittedUserSearchRequest(@Nonnull AbstractBuilder builder) {
        Objects.requireNonNull(builder, "builder");
        this.userType = Objects.requireNonNull(builder.userType, "userType");
        this.nameFilter = builder.nameFilter;
    }

    @Nonnull
    public UserType getUserType() {
        return this.userType;
    }

    @Nullable
    public String getNameFilter() {
        return this.nameFilter;
    }

    public abstract <T> T accept(@Nonnull Visitor<T> var1);

    public static interface Visitor<T> {
        public T visit(@Nonnull PermittedUserGlobalSearchRequest var1);

        public T visit(@Nonnull PermittedUserProjectSearchRequest var1);

        public T visit(@Nonnull PermittedUserRepositorySearchRequest var1);
    }

    public static class RepositoryBuilder
    extends AbstractBuilder<RepositoryBuilder, PermittedUserRepositorySearchRequest> {
        Repository repository;

        public RepositoryBuilder(@Nonnull PermittedUserRepositorySearchRequest request) {
            super(request);
            this.repository = request.getRepository();
        }

        private RepositoryBuilder(@Nonnull AbstractBuilder builder, @Nonnull Repository repository) {
            super(builder);
            this.repository = repository;
        }

        @Override
        public PermittedUserRepositorySearchRequest build() {
            return new PermittedUserRepositorySearchRequest(this);
        }

        @Override
        protected RepositoryBuilder self() {
            return this;
        }
    }

    public static class ProjectBuilder
    extends AbstractBuilder<ProjectBuilder, PermittedUserProjectSearchRequest> {
        Project project;

        public ProjectBuilder(@Nonnull PermittedUserProjectSearchRequest request) {
            super(request);
            this.project = request.getProject();
        }

        private ProjectBuilder(@Nonnull AbstractBuilder builder, @Nonnull Project project) {
            super(builder);
            this.project = project;
        }

        @Override
        public PermittedUserProjectSearchRequest build() {
            return new PermittedUserProjectSearchRequest(this);
        }

        @Override
        protected ProjectBuilder self() {
            return this;
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder, PermittedUserGlobalSearchRequest> {
        public Builder() {
        }

        public Builder(@Nonnull PermittedUserSearchRequest request) {
            super(request);
        }

        @Override
        @Nonnull
        public PermittedUserGlobalSearchRequest build() {
            return new PermittedUserGlobalSearchRequest(this);
        }

        @Nonnull
        public ProjectBuilder project(@Nonnull Project project) {
            return new ProjectBuilder(this, project);
        }

        @Nonnull
        public RepositoryBuilder repository(@Nonnull Repository repository) {
            return new RepositoryBuilder(this, repository);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder, R extends PermittedUserSearchRequest> {
        protected String nameFilter;
        protected UserType userType = UserType.NORMAL;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(@Nonnull AbstractBuilder<B, R> builder) {
            this.nameFilter = builder.nameFilter;
            this.userType = builder.userType;
        }

        protected AbstractBuilder(@Nonnull PermittedUserSearchRequest request) {
            this.nameFilter = request.getNameFilter();
            this.userType = request.getUserType();
        }

        public B userType(UserType userType) {
            this.userType = userType;
            return this.self();
        }

        public B nameFilter(String filter) {
            this.nameFilter = filter;
            return this.self();
        }

        public abstract R build();

        protected abstract B self();
    }
}

