/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.secretscanning;

import com.atlassian.bitbucket.dmz.secretscanning.SecretScanningRuleOrder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class SecretScanningRuleSearchRequest {
    private final String filterText;
    private final SecretScanningRuleOrder order;

    private SecretScanningRuleSearchRequest(Builder builder) {
        this.filterText = builder.filterText;
        this.order = (SecretScanningRuleOrder)((Object)ObjectUtils.firstNonNull((Object[])new SecretScanningRuleOrder[]{builder.order, SecretScanningRuleOrder.NAME_ASC}));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretScanningRuleSearchRequest that = (SecretScanningRuleSearchRequest)o;
        return Objects.equals(this.filterText, that.filterText) && this.order == that.order;
    }

    @Nonnull
    public Optional<String> getFilterText() {
        return Optional.ofNullable(this.filterText);
    }

    @Nonnull
    public SecretScanningRuleOrder getOrder() {
        return this.order;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filterText, this.order});
    }

    public static class Builder {
        private String filterText;
        private SecretScanningRuleOrder order;

        @Nonnull
        public SecretScanningRuleSearchRequest build() {
            return new SecretScanningRuleSearchRequest(this);
        }

        @Nonnull
        public Builder filterText(@Nullable String filterText) {
            this.filterText = StringUtils.trimToNull((String)filterText);
            return this;
        }

        @Nonnull
        public Builder order(@Nullable SecretScanningRuleOrder order) {
            this.order = order;
            return this;
        }
    }
}

