/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.ratelimit;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

public class TokenBucketSettings {
    public static TokenBucketSettings recommendedSettings = new Builder().build();
    private final int capacity;
    private final int fillRate;

    private TokenBucketSettings(Builder builder) {
        this.capacity = builder.capacity;
        this.fillRate = builder.fillRate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TokenBucketSettings)) {
            return false;
        }
        TokenBucketSettings that = (TokenBucketSettings)o;
        return this.capacity == that.capacity && this.fillRate == that.fillRate;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getFillRate() {
        return this.fillRate;
    }

    public int hashCode() {
        return Objects.hash(this.capacity, this.fillRate);
    }

    public String toString() {
        return "TokenBucketSettings{capacity=" + this.capacity + ", fillRate=" + this.fillRate + '}';
    }

    public static class Builder {
        private int capacity;
        private int fillRate;

        public Builder() {
            this.capacity = 60;
            this.fillRate = 5;
        }

        public Builder(@Nonnull TokenBucketSettings settings) {
            Objects.requireNonNull(settings, "settings");
            this.capacity = settings.getCapacity();
            this.fillRate = settings.getFillRate();
        }

        @Nonnull
        public TokenBucketSettings build() {
            return new TokenBucketSettings(this);
        }

        @Nonnull
        public Builder capacity(int value) {
            Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"capacity was %s, expected > 0", (int)value);
            this.capacity = value;
            return this;
        }

        @Nonnull
        public Builder fillRate(int value) {
            Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"fillRate was %s, expected > 0", (int)value);
            this.fillRate = value;
            return this;
        }
    }
}

