/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.policy;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.event.api.AsynchronousPreferred;
import java.util.Objects;
import javax.annotation.Nonnull;

@AsynchronousPreferred
@TransactionAware
public abstract class PolicyChangedEvent
extends ApplicationEvent {
    private final Permission newPolicy;
    private final Permission oldPolicy;

    protected PolicyChangedEvent(@Nonnull Object source, @Nonnull Permission oldPolicy, @Nonnull Permission newPolicy) {
        super(source);
        this.newPolicy = Objects.requireNonNull(newPolicy, "newPolicy");
        this.oldPolicy = Objects.requireNonNull(oldPolicy, "oldPolicy");
    }

    public abstract boolean getIsNewDefault();

    public abstract boolean getIsOldDefault();

    @Nonnull
    public Permission getNewPolicy() {
        return this.newPolicy;
    }

    @Nonnull
    public Permission getOldPolicy() {
        return this.oldPolicy;
    }
}

