/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationJobState;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class MeshPartitionMigrationSearchRequest {
    private final Integer partition;
    private final Set<Long> sourceNodeIds;
    private final Set<MeshPartitionMigrationJobState> states;
    private final Set<Long> targetNodeIds;

    private MeshPartitionMigrationSearchRequest(Builder builder) {
        this.partition = builder.partition;
        this.sourceNodeIds = ImmutableSet.copyOf((Collection)builder.sourceNodeIds);
        this.targetNodeIds = ImmutableSet.copyOf((Collection)builder.targetNodeIds);
        this.states = ImmutableSet.copyOf((Collection)builder.states);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeshPartitionMigrationSearchRequest that = (MeshPartitionMigrationSearchRequest)o;
        return Objects.equals(this.targetNodeIds, that.targetNodeIds) && Objects.equals(this.partition, that.partition) && Objects.equals(this.states, that.states);
    }

    @Nonnull
    public OptionalInt getPartition() {
        return this.partition == null ? OptionalInt.empty() : OptionalInt.of(this.partition);
    }

    @Nonnull
    public Set<Long> getSourceNodeIds() {
        return this.sourceNodeIds;
    }

    @Nonnull
    public Set<MeshPartitionMigrationJobState> getStates() {
        return this.states;
    }

    @Nonnull
    public Set<Long> getTargetNodeIds() {
        return this.targetNodeIds;
    }

    public int hashCode() {
        return Objects.hash(this.targetNodeIds, this.partition, this.states);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("targetNodeIds", this.targetNodeIds).append("partition", (Object)this.partition).append("states", this.states).toString();
    }

    public static class Builder {
        private final Set<Long> sourceNodeIds;
        private final Set<MeshPartitionMigrationJobState> states = EnumSet.noneOf(MeshPartitionMigrationJobState.class);
        private final Set<Long> targetNodeIds = new HashSet<Long>();
        private Integer partition;

        public Builder() {
            this.sourceNodeIds = new HashSet<Long>();
        }

        @Nonnull
        public MeshPartitionMigrationSearchRequest build() {
            return new MeshPartitionMigrationSearchRequest(this);
        }

        @Nonnull
        public Builder partition(@Nullable Integer value) {
            this.partition = value;
            return this;
        }

        @Nonnull
        public Builder sourceNodeId(long value) {
            this.sourceNodeIds.add(value);
            return this;
        }

        @Nonnull
        public Builder sourceNodeIds(@Nonnull Iterable<Long> values) {
            Objects.requireNonNull(values, "sourceNodeIds");
            values.forEach(this.sourceNodeIds::add);
            return this;
        }

        @Nonnull
        public Builder states(MeshPartitionMigrationJobState ... values) {
            this.states.addAll(Arrays.asList((Object[])Objects.requireNonNull(values, "states")));
            return this;
        }

        @Nonnull
        public Builder states(@Nonnull Iterable<MeshPartitionMigrationJobState> values) {
            Objects.requireNonNull(values, "states");
            values.forEach(this.states::add);
            return this;
        }

        @Nonnull
        public Builder targetNodeId(long value) {
            this.targetNodeIds.add(value);
            return this;
        }

        @Nonnull
        public Builder targetNodeIds(@Nonnull Iterable<Long> values) {
            Objects.requireNonNull(values, "targetNodeIds");
            values.forEach(this.targetNodeIds::add);
            return this;
        }
    }
}

