/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.build.status;

import com.atlassian.bitbucket.dmz.build.status.AbstractBuildStatusSummaryRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public final class BulkPullRequestBuildStatusSummaryRequest
extends AbstractBuildStatusSummaryRequest {
    private final Set<Long> pullRequestIds;

    private BulkPullRequestBuildStatusSummaryRequest(Builder builder) {
        super(builder);
        this.pullRequestIds = builder.pullRequestIds.build();
    }

    @Nonnull
    public Set<Long> getPullRequestIds() {
        return this.pullRequestIds;
    }

    public static class Builder
    extends AbstractBuildStatusSummaryRequest.AbstractBuilder<Builder> {
        private final ImmutableSet.Builder<Long> pullRequestIds = new ImmutableSet.Builder();

        public Builder(Repository repository, Long ... pullRequestIds) {
            super(Objects.requireNonNull(repository, "repository"));
            this.pullRequestIds.addAll(Arrays.asList(pullRequestIds));
        }

        public Builder(@Nonnull BulkPullRequestBuildStatusSummaryRequest request) {
            super(Objects.requireNonNull(request, "request"));
            this.pullRequestIds.addAll(request.getPullRequestIds());
        }

        @Override
        @Nonnull
        public BulkPullRequestBuildStatusSummaryRequest build() {
            return new BulkPullRequestBuildStatusSummaryRequest(this);
        }

        public Builder pullRequestIds(@Nonnull Collection<Long> values) {
            Objects.requireNonNull(values, "pullRequestIds");
            this.pullRequestIds.addAll(values);
            return this.self();
        }

        @Override
        @Nonnull
        public Builder self() {
            return this;
        }
    }
}

