/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.build;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class BuildStatusOperationRequest {
    private final String actionId;
    private final String buildKey;
    private final String commitId;
    private final Repository repository;

    private BuildStatusOperationRequest(Builder builder) {
        this.actionId = builder.actionId;
        this.buildKey = builder.buildKey;
        this.commitId = builder.commitId;
        this.repository = builder.repository;
    }

    @Nonnull
    public String getActionId() {
        return this.actionId;
    }

    @Nonnull
    public String getBuildKey() {
        return this.buildKey;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static final class Builder
    extends BuilderSupport {
        private final String actionId;
        private final String buildKey;
        private final String commitId;
        private final Repository repository;

        public Builder(@Nonnull String actionId, @Nonnull String buildKey, @Nonnull String commitId, @Nonnull Repository repository) {
            this.actionId = Builder.requireNonBlank((String)actionId, (String)"actionId");
            this.buildKey = Builder.requireNonBlank((String)buildKey, (String)"key");
            this.commitId = Builder.requireNonBlank((String)commitId, (String)"commitId");
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        @Nonnull
        public BuildStatusOperationRequest build() {
            return new BuildStatusOperationRequest(this);
        }
    }
}

