/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import liquibase.database.AbstractDatabase;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.integration.spring.SpringLiquibase;
import liquibase.lockservice.LockService;

public class DefaultingSchemaLiquibase
extends SpringLiquibase {
    private long lockMaxWait;
    private long lockPollInterval;

    public DefaultingSchemaLiquibase(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public void afterPropertiesSet() throws LiquibaseException {
        try (Connection c = this.getDataSource().getConnection();){
            this.performUpdate(this.createLiquibase(c));
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public void setLockMaxWait(long lockMaxWait) {
        this.lockMaxWait = TimeUnit.SECONDS.toMillis(Math.max(1L, lockMaxWait));
    }

    public void setLockPollInterval(long lockPollInterval) {
        this.lockPollInterval = TimeUnit.SECONDS.toMillis(Math.max(1L, lockPollInterval));
    }

    protected Database createDatabase(Connection c) throws DatabaseException {
        Database database = super.createDatabase(c);
        if (database instanceof AbstractDatabase) {
            database.setDefaultSchemaName(((AbstractDatabase)database).getDefaultDatabaseSchemaName());
        }
        LockService lockService = LockService.getInstance((Database)database);
        lockService.setChangeLogLockRecheckTime(this.lockPollInterval);
        lockService.setChangeLogLockWaitTime(this.lockMaxWait);
        return database;
    }
}

