/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermittedGroup;
import com.atlassian.bitbucket.permission.PermittedUser;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.experimental.user.RepositoryPermission;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.user.AbstractHibernateGrantedPermissionDao;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalRepositoryPermission;
import com.atlassian.stash.internal.user.PartitionedGroups;
import com.atlassian.stash.internal.user.RepositoryPermissionDao;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Repository(value="grantedRepositoryPermissionDao")
public class HibernateRepositoryPermissionDao
extends AbstractHibernateGrantedPermissionDao<InternalRepositoryPermission>
implements RepositoryPermissionDao {
    @Autowired
    public HibernateRepositoryPermissionDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    protected Criteria createHasPermissionEntryCriteria(InternalRepositoryPermission grantedPermission) {
        return super.createHasPermissionEntryCriteria(grantedPermission).add((Criterion)Restrictions.eq((String)"repository", (Object)grantedPermission.getRepository()));
    }

    private Criterion createRestriction(int repositoryId) {
        return Restrictions.eq((String)"repository.id", (Object)repositoryId);
    }

    @Nonnull
    public Page<PermittedUser> findHighestPermissionPerUser(int repositoryId, @Nonnull UserType userType, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        Page<ApplicationUser> page = this.findUsersWithPermission(userType, filter, pageRequest, this.createRestriction(repositoryId));
        if (page.getIsLastPage() && page.getSize() == 0) {
            return HibernatePageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        Query query = this.createFindHighestPermissionPerUserQuery(page, "repository.id = :repositoryId").setInteger("repositoryId", repositoryId);
        return this.pairUsersWithPermissions(page, query);
    }

    @Nonnull
    public Page<ApplicationUser> findUsersWithPermission(int repositoryId, @Nonnull UserType userType, @Nonnull PageRequest pageRequest) {
        return this.findUsersWithPermission(userType, null, pageRequest, this.createRestriction(repositoryId));
    }

    @Nonnull
    public Page<PermittedGroup> findHighestPermissionPerGroup(int repositoryId, @Nullable String filter, @Nonnull PageRequest pageRequest) {
        Query query = this.createFindHighestPermissionPerGroupQuery(filter, "repository.id = :repositoryId").setInteger("repositoryId", repositoryId);
        return HibernatePageUtils.pageQuery(query, pageRequest);
    }

    @Nonnull
    public Page<String> findGroupsWithPermission(int repositoryId, @Nonnull PageRequest pageRequest) {
        return this.findGroupsWithPermission(pageRequest, this.createRestriction(repositoryId));
    }

    public int revoke(@Nonnull InternalRepositoryPermission grantedPermission) {
        return this.createRevokeQuery((InternalGrantedPermission)grantedPermission, "repository.id = :repositoryId").setInteger("repositoryId", grantedPermission.getRepository().getId()).executeUpdate();
    }

    public long countWithPermission(int userId, @Nonnull PartitionedGroups allGroups, int projectId) {
        Iterator i = allGroups.iterator();
        Collection first = (Collection)i.next();
        if (i.hasNext()) {
            HashSet ids = Sets.newHashSet();
            ids.addAll(this.getRepositoriesWithPermission(userId, first, projectId));
            while (i.hasNext()) {
                Collection groups = (Collection)i.next();
                ids.addAll(this.getRepositoriesWithPermission(userId, groups, projectId));
            }
            return ids.size();
        }
        return this.countRepositoriesWithPermission(userId, first, projectId);
    }

    @Nullable
    public Permission getHighestPermissionForUser(int userId, int repositoryId) {
        Query query = this.session().createQuery("select max(t.weight) from InternalRepositoryPermission p, InternalPermissionType t where p.permission = t.id and p.repository.id = :repositoryId and p.group is null and p.user.id = :userId").setParameter("userId", (Object)userId).setParameter("repositoryId", (Object)repositoryId);
        Integer maxWeight = (Integer)query.uniqueResult();
        return maxWeight == null ? null : Permission.fromWeight((int)maxWeight);
    }

    @Nonnull
    public Page<RepositoryPermission> findHighestPermissionsForUser(int userId, @Nonnull PageRequest pageRequest) {
        Query query = this.session().createQuery("select new com.atlassian.stash.internal.user.InternalGrantedRepositoryPermission(r, max(t.weight)) from InternalRepositoryPermission p, InternalPermissionType t, InternalRepository r, InternalProject pj where p.permission = t.id and p.repository.id = r.id and r.project.id = pj.id and p.group is null and p.user.id = :userId group by r.id, pj.name, r.name order by pj.name, r.name ").setParameter("userId", (Object)userId);
        return HibernateUtils.initializePage(HibernatePageUtils.pageQuery(query, pageRequest));
    }

    public long countRepositoriesWithPermission(int userId, Collection<String> groups, int projectId) {
        return (Long)this.repositoriesWithPermission(userId, groups, projectId).setProjection((Projection)Projections.countDistinct((String)"repository.id")).uniqueResult();
    }

    public List<Long> getRepositoriesWithPermission(int userId, Collection<String> groups, int projectId) {
        return this.repositoriesWithPermission(userId, groups, projectId).setProjection(Projections.distinct((Projection)Projections.property((String)"repository.id"))).list();
    }

    private Criteria repositoriesWithPermission(int userId, Collection<String> groups, int projectId) {
        return this.session().createCriteria(this.entityClass).createAlias("repository", "joinRepository").add(Restrictions.in((String)"permission", (Collection)Permission.getPermissionsOn(Repository.class))).add((Criterion)Restrictions.eq((String)"joinRepository.project.id", (Object)projectId)).add((Criterion)(groups.isEmpty() ? Restrictions.and((Criterion)Restrictions.eq((String)"user.id", (Object)userId), (Criterion)Restrictions.isNull((String)"group")) : Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"user.id", (Object)userId), (Criterion)Restrictions.isNull((String)"group")), (Criterion)Restrictions.and((Criterion)Restrictions.isNull((String)"user"), (Criterion)Restrictions.in((String)"group", (Collection)Collections2.transform(groups, (Function)IdentifierUtils.TO_LOWER_CASE))))));
    }
}

