/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.activity.AbstractHibernateActivityDao;
import com.atlassian.stash.internal.activity.ActivityLock;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionCommentActivity;
import com.atlassian.stash.internal.repository.InternalRepositoryActivity;
import com.atlassian.stash.internal.repository.RepositoryActivityDao;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="repositoryActivityDao")
public class HibernateRepositoryActivityDao
extends AbstractHibernateActivityDao<InternalRepositoryActivity>
implements RepositoryActivityDao {
    @Autowired
    public HibernateRepositoryActivityDao(SessionFactory sessionFactory, ActivityLock activityLock) {
        super(sessionFactory, activityLock);
    }

    @Nonnull
    public Map<String, Long> countCommentsByCommit(int repositoryId, @Nonnull Set<String> commitIds) {
        if (commitIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List results = this.session().createQuery("select d.commitId, count(*) from InternalCommitDiscussionCommentActivity a join a.discussion d where d.repository.id = :repositoryId and d.commitId in (:commitIds) and a.commentAction in (:actions) group by d.commitId").setInteger("repositoryId", repositoryId).setParameterList("commitIds", commitIds).setParameterList("actions", EnumSet.of(CommentAction.ADDED, CommentAction.REPLIED)).list();
        HashMap<String, Long> counts = new HashMap<String, Long>(results.size(), 1.0f);
        for (Object result : results) {
            Object[] columns = (Object[])result;
            counts.put((String)columns[0], (Long)columns[1]);
        }
        return counts;
    }

    public int deleteByComment(long commentId) {
        try (LockGuard ignored = this.activityLock.forDelete();){
            int n = this.session().createQuery("delete from InternalCommitDiscussionCommentActivity where comment.id = :commentId").setLong("commentId", commentId).executeUpdate();
            return n;
        }
    }

    public int deleteByRepository(int repositoryId) {
        return this.maybeBulkDelete("from InternalRepositoryActivity where repository.id = :repositoryId", (Map<String, Object>)ImmutableMap.of((Object)"repositoryId", (Object)repositoryId));
    }

    public InternalCommitDiscussionCommentActivity findByComment(long commentId) {
        return (InternalCommitDiscussionCommentActivity)HibernateUtils.initialize((Object)((InternalCommitDiscussionCommentActivity)this.session().createCriteria(InternalCommitDiscussionCommentActivity.class).add((Criterion)Restrictions.eq((String)"comment.id", (Object)commentId)).add((Criterion)Restrictions.eq((String)"commentAction", (Object)CommentAction.ADDED)).uniqueResult()));
    }

    @Nonnull
    public Page<InternalRepositoryActivity> findByRepository(int repositoryId, @Nonnull PageRequest pageRequest) {
        return HibernateUtils.initializePage(this.getPageOfActivites(repositoryId, pageRequest));
    }

    @Override
    public InternalRepositoryActivity update(InternalRepositoryActivity entity) {
        throw new UnsupportedOperationException("RepositoryActivities are immutable and cannot be updated.");
    }

    private Page<InternalRepositoryActivity> getPageOfActivites(int repositoryId, PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(InternalRepositoryActivity.class).add((Criterion)Restrictions.eq((String)"repository.id", (Object)repositoryId)).add(Restrictions.not((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"type", (Object)5), (Criterion)Restrictions.ne((String)"commentAction", (Object)CommentAction.ADDED))));
        return this.pageCriteria(this.applyImplicitOrder(criteria), pageRequest);
    }
}

