/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.hibernate.HibernatePageUtils;
import com.atlassian.stash.internal.participant.AbstractHibernateParticipantDao;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import com.atlassian.stash.internal.pull.PullRequestParticipantDao;
import com.atlassian.stash.internal.pull.PullRequestParticipantSearchCriteria;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="pullRequestParticipantDao")
public class HibernatePullRequestParticipantDao
extends AbstractHibernateParticipantDao<InternalPullRequestParticipant>
implements PullRequestParticipantDao {
    @Autowired
    public HibernatePullRequestParticipantDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Nonnull
    public Page<InternalPullRequestParticipant> findByPullRequest(long pullRequestId, @Nonnull PageRequest pageRequest) {
        Criteria criteria = this.session().createCriteria(InternalPullRequestParticipant.class).add((Criterion)Restrictions.eq((String)"pullRequest.id", (Object)pullRequestId));
        return HibernateUtils.initializePage(this.pageCriteria(this.applyImplicitOrder(criteria), pageRequest));
    }

    @Nullable
    public InternalPullRequestParticipant findByPullRequestAndUser(long pullRequestId, int userId) {
        Criteria criteria = this.session().createCriteria(InternalPullRequestParticipant.class).add((Criterion)Restrictions.eq((String)"pullRequest.id", (Object)pullRequestId)).add((Criterion)Restrictions.eq((String)"user.id", (Object)userId));
        return (InternalPullRequestParticipant)HibernateUtils.initialize((Object)((InternalPullRequestParticipant)criteria.uniqueResult()));
    }

    @Nonnull
    public Page<InternalApplicationUser> searchUsers(@Nonnull PullRequestParticipantSearchCriteria searchCriteria, @Nonnull PageRequest pageRequest) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select user ").append("from InternalNormalUser user where user.id in (").append("select distinct participant.user.id from InternalPullRequestParticipant as participant");
        Optional fromRepository = searchCriteria.getFromRepository();
        Optional toRepository = searchCriteria.getToRepository();
        if (fromRepository.isPresent() || toRepository.isPresent()) {
            querySql.append(" inner join participant.pullRequest as pull");
            fromRepository.ifPresent(repository -> querySql.append(" with pull.fromRef.repository.id = :fromRepoId"));
            toRepository.ifPresent(repository -> {
                if (fromRepository.isPresent()) {
                    querySql.append(" and");
                } else {
                    querySql.append(" with");
                }
                querySql.append(" pull.toRef.repository.id  = :toRepoId");
            });
        }
        searchCriteria.getRole().ifPresent(role -> querySql.append(" where participant.role = :role"));
        querySql.append(" )");
        querySql.append(" order by user.username asc");
        Query query = this.session().createQuery(querySql.toString());
        fromRepository.ifPresent(repository -> query.setInteger("fromRepoId", repository.getId()));
        toRepository.ifPresent(repository -> query.setInteger("toRepoId", repository.getId()));
        searchCriteria.getRole().ifPresent(role -> query.setParameter("role", role));
        query.setCacheable(true);
        query.setCacheRegion("query.pullRequestParticipantUsers");
        return HibernateUtils.initializePage(HibernatePageUtils.pageQuery(query, pageRequest));
    }

    public int resetStatusByPullRequest(long pullRequestId) {
        return this.session().createQuery("update InternalPullRequestParticipant set status = :current where pullRequest.id = :pullRequest and status = :previous").setParameter("current", (Object)PullRequestParticipantStatus.UNAPPROVED).setLong("pullRequest", pullRequestId).setParameter("previous", (Object)PullRequestParticipantStatus.NEEDS_WORK).executeUpdate();
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Arrays.asList(Order.asc((String)"role"), Order.asc((String)"id"));
    }
}

