/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class PostgresClobToStringChange
extends AbstractCustomChange
implements CustomTaskChange {
    public static final String SELECT_SQL = "select %1$s, %2$s from %3$s";
    public static final String UPDATE_SQL = "update %3$s set %2$s = ? where %1$s = ?";
    private String columnName;
    private String primaryKeyColumnName;
    private String schemaName;
    private String tableName;
    private int total;
    private int updated;

    public void execute(Database database) throws CustomChangeException {
        String table = database.escapeTableName(this.schemaName, this.tableName);
        String column = database.escapeColumnName(this.schemaName, this.tableName, this.columnName);
        String primaryKeyColumn = database.escapeColumnName(this.schemaName, this.tableName, this.primaryKeyColumnName);
        String select = String.format(SELECT_SQL, primaryKeyColumn, column, table);
        final String update = String.format(UPDATE_SQL, primaryKeyColumn, column, table);
        final JdbcTemplate template = LiquibaseUtils.getJdbcTemplate((Database)database);
        template.query(select, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                block2: {
                    ++PostgresClobToStringChange.this.total;
                    try {
                        Clob clob = resultSet.getClob(2);
                        Object id = resultSet.getObject(1);
                        String value = this.toString(clob);
                        template.update(update, new Object[]{value, id}, new int[]{-1, resultSet.getMetaData().getColumnType(1)});
                        ++PostgresClobToStringChange.this.updated;
                    }
                    catch (SQLException e) {
                        if ("22003".equals(e.getSQLState())) break block2;
                        throw e;
                    }
                }
            }

            private String toString(Clob clob) throws SQLException {
                InputStream stream = clob.getAsciiStream();
                try {
                    return CharStreams.toString((Readable)new InputStreamReader(stream, Charset.forName("ASCII")));
                }
                catch (IOException e) {
                    throw new SQLException("Failed to read CLOB contents", e);
                }
            }
        });
    }

    public String getConfirmationMessage() {
        return String.format("Converted CLOBs to Strings for %1$d of %2$d rows in %3$s", this.updated, this.total, this.tableName);
    }

    @Override
    public void setUp() throws SetupException {
        this.notBlank(this.columnName, "columnName");
        this.notBlank(this.primaryKeyColumnName, "primaryKeyColumnName");
        this.notBlank(this.tableName, "tableName");
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setPrimaryKeyColumnName(String primaryKeyColumnName) {
        this.primaryKeyColumnName = primaryKeyColumnName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

