/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.liquibase;

import com.atlassian.stash.internal.liquibase.AbstractCustomChange;
import com.atlassian.stash.internal.liquibase.LiquibaseUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.change.custom.CustomTaskChange;
import liquibase.change.custom.CustomTaskRollback;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.UnsupportedChangeException;

public class PopulateSurrogateKeyChange
extends AbstractCustomChange
implements CustomTaskChange,
CustomTaskRollback {
    private int batchSize = 500;
    private Set<String> compositeKeyColumnNames;
    private int incrementSize = 1;
    private String surrogateKeyColumnName;
    private String tableName;

    public String getConfirmationMessage() {
        return String.format("Populate surrogate key %1$s for table %2$s with composite primary key %3$s", this.surrogateKeyColumnName, this.tableName, Joiner.on((String)", ").join(this.compositeKeyColumnNames));
    }

    public void execute(Database database) throws CustomChangeException {
        try {
            List<Map<String, String>> compositeKeyBatch;
            long processed = 0L;
            do {
                if ((compositeKeyBatch = this.selectCompositeKeys(database)).isEmpty()) continue;
                processed += (long)this.updateSurrogateKeys(database, compositeKeyBatch, processed);
            } while (compositeKeyBatch.size() >= this.batchSize);
            if (processed > 0L) {
                this.insertIdSequence(database, processed);
            }
        }
        catch (SQLException e) {
            throw new CustomChangeException((Throwable)e);
        }
    }

    private void insertIdSequence(Database database, long processed) throws SQLException {
        String insertSql = "insert into id_sequence (sequence_name, next_val) values (?, ?)";
        try (PreparedStatement ps = LiquibaseUtils.getConnection((Database)database).prepareStatement(insertSql);){
            ps.setString(1, this.tableName);
            ps.setLong(2, (long)(this.incrementSize * 2) + processed);
            ps.executeUpdate();
        }
    }

    private int updateSurrogateKeys(Database database, List<Map<String, String>> batch, long processedPreviously) throws SQLException {
        StringBuilder updateSql = new StringBuilder("update ").append(database.escapeTableName(null, this.tableName)).append(" set ").append(database.escapeColumnName(null, this.tableName, this.surrogateKeyColumnName)).append(" = ? where ");
        String sep = "";
        for (String compositeKeyColumnName : this.compositeKeyColumnNames) {
            updateSql.append(sep).append(database.escapeColumnName(null, this.tableName, compositeKeyColumnName)).append(" = ? ");
            sep = "and ";
        }
        int processed = 0;
        try (PreparedStatement ps = LiquibaseUtils.getConnection((Database)database).prepareStatement(updateSql.toString());){
            for (Map<String, String> compositeKey : batch) {
                ps.setLong(1, processedPreviously + (long)(++processed));
                int i = 1;
                for (String compositeKeyColumnName : this.compositeKeyColumnNames) {
                    ps.setString(++i, compositeKey.get(compositeKeyColumnName));
                }
                ps.addBatch();
            }
            ps.executeBatch();
            int n = processed;
            return n;
        }
    }

    private List<Map<String, String>> selectCompositeKeys(Database database) throws SQLException {
        String columns = Joiner.on((String)", ").join(this.compositeKeyColumnNames);
        String selectSql = "select " + database.escapeColumnNameList(columns) + " from " + database.escapeTableName(null, this.tableName) + " where " + database.escapeColumnName(null, this.tableName, this.surrogateKeyColumnName) + " is NULL";
        try (PreparedStatement ps = LiquibaseUtils.getConnection((Database)database).prepareStatement(selectSql);){
            ps.setMaxRows(this.batchSize);
            ImmutableList.Builder batchBuilder = ImmutableList.builder();
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ImmutableMap.Builder builder = ImmutableMap.builder();
                    for (String compositeKeyColumnName : this.compositeKeyColumnNames) {
                        builder.put((Object)compositeKeyColumnName, (Object)rs.getString(compositeKeyColumnName));
                    }
                    batchBuilder.add((Object)builder.build());
                }
            }
            ImmutableList immutableList = batchBuilder.build();
            return immutableList;
        }
    }

    public void rollback(Database database) throws CustomChangeException, UnsupportedChangeException, RollbackImpossibleException {
        Connection connection = LiquibaseUtils.getConnection((Database)database);
        String updateSql = "update " + database.escapeTableName(null, this.tableName) + " set " + database.escapeColumnName(null, this.tableName, this.surrogateKeyColumnName) + " = NULL";
        try (PreparedStatement ps = connection.prepareStatement(updateSql);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new CustomChangeException((Throwable)e);
        }
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setCompositeKeyColumnNames(String compositeKeyColumnNames) {
        this.compositeKeyColumnNames = ImmutableSet.copyOf((Object[])compositeKeyColumnNames.split("\\s*,\\s*"));
    }

    public void setIncrementSize(Integer incrementSize) {
        this.incrementSize = incrementSize;
    }

    public void setSurrogateKeyColumnName(String surrogateKeyColumnName) {
        this.surrogateKeyColumnName = surrogateKeyColumnName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

