/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hibernate;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.stash.internal.user.InternalNormalUser;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.event.internal.DefaultLoadEventListener;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CrowdAwareLoadListener
extends DefaultLoadEventListener
implements ApplicationContextAware,
PostLoadEventListener {
    private static final Logger log = LoggerFactory.getLogger(CrowdAwareLoadListener.class);
    private final String crowdServiceBeanName;
    private final Object lock;
    private ApplicationContext applicationContext;
    private volatile CrowdService crowdService;

    public CrowdAwareLoadListener(String crowdServiceBeanName) {
        this.crowdServiceBeanName = crowdServiceBeanName;
        this.lock = new Object();
    }

    public void onPostLoad(PostLoadEvent event) {
        this.setCrowdUserIfNecessary(event.getEntity());
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected Object load(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        Object loaded = super.load(event, persister, keyToLoad, options);
        this.setCrowdUserIfNecessary(loaded);
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User getCrowdUser(String username) {
        if (username == null) {
            return null;
        }
        if (this.crowdService == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.crowdService == null) {
                    this.crowdService = (CrowdService)this.applicationContext.getBean(this.crowdServiceBeanName, CrowdService.class);
                }
            }
        }
        try {
            return this.crowdService.getUser(username);
        }
        catch (ObjectNotFoundException e) {
            log.debug("Loading the associated crowd user with name '{}' failed", (Object)username, (Object)e);
            return null;
        }
    }

    private void setCrowdUserIfNecessary(Object loaded) {
        InternalNormalUser user;
        if (loaded instanceof InternalNormalUser && !(user = (InternalNormalUser)loaded).isCrowdBacked()) {
            user.setBackingCrowdUser(this.getCrowdUser(user.getUsername()));
        }
    }
}

