/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.group;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.group.DeletedGroupDao;
import com.atlassian.stash.internal.group.InternalDeletedGroup;
import java.util.Collections;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="deletedGroupDao")
public class HibernateDeletedGroupDao
extends AbstractHibernateDao<Integer, InternalDeletedGroup>
implements DeletedGroupDao {
    private static final String FIELD_DELETED_DATE = "deletedDate";
    private static final String FIELD_NAME = "name";

    @Autowired
    public HibernateDeletedGroupDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.asc((String)FIELD_DELETED_DATE));
    }

    @Nonnull
    public Page<InternalDeletedGroup> findByDeletedDateEarlierThan(@Nonnull Date date, @Nonnull PageRequest pageRequest) {
        Query query = this.session().createQuery("from InternalDeletedGroup where deletedDate < :deletedDate order by name").setParameter(FIELD_DELETED_DATE, (Object)date);
        return PageUtils.asPageOf(InternalDeletedGroup.class, this.pageQuery(query, pageRequest));
    }

    @Nullable
    public InternalDeletedGroup findByName(@Nonnull String name) {
        return (InternalDeletedGroup)this.session().createQuery("from InternalDeletedGroup where name = :name").setParameter(FIELD_NAME, (Object)IdentifierUtils.toLowerCase((String)name)).uniqueResult();
    }
}

