/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.auth.InternalRememberMeToken;
import com.atlassian.stash.internal.auth.RememberMeTokenDao;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Repository;

@Repository(value="rememberMeTokenDao")
public class HibernateRememberMeTokenDao
extends AbstractHibernateDao<Long, InternalRememberMeToken>
implements RememberMeTokenDao {
    @Autowired
    public HibernateRememberMeTokenDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public boolean claim(@Nonnull InternalRememberMeToken token) {
        int updated = this.session().createQuery("update InternalRememberMeToken set expiryDate = :newExpiry, claimed = true, remoteAddress = :hostname where series = :series and token = :token and claimed = false and expiryDate > :now").setTimestamp("newExpiry", token.getExpiryDate()).setString("hostname", token.getRemoteAddress()).setString("series", token.getSeries()).setString("token", token.getToken()).setDate("now", new Date()).executeUpdate();
        if (updated > 1) {
            throw new DataIntegrityViolationException("more than one remember-me token was claimed");
        }
        return updated == 1;
    }

    public int deleteExpiredTokens(long maxExpiredTime, @Nonnull TimeUnit timeUnit) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(13, (int)(-timeUnit.toSeconds(maxExpiredTime)));
        Date maxExpiredDate = calendar.getTime();
        return this.session().createQuery("delete from InternalRememberMeToken where expiryDate < :expiryDate").setTimestamp("expiryDate", maxExpiredDate).executeUpdate();
    }

    public int deleteForSeries(@Nonnull String series) {
        return this.session().createQuery("delete from InternalRememberMeToken where series = :series").setString("series", series).executeUpdate();
    }

    public int deleteForUser(int userId) {
        return this.session().createQuery("delete from InternalRememberMeToken where user.id = :userId").setInteger("userId", userId).executeUpdate();
    }

    @Override
    @Nonnull
    public Page<InternalRememberMeToken> findAll(PageRequest pageRequest) {
        return HibernateUtils.initializePage(super.findAll(pageRequest));
    }

    @Override
    @Nonnull
    public Page<InternalRememberMeToken> findAll(PageRequest pageRequest, Predicate<? super InternalRememberMeToken> predicate) {
        return HibernateUtils.initializePage(super.findAll(pageRequest, predicate));
    }

    @Nullable
    public InternalRememberMeToken findBySeriesAndToken(@Nonnull String series, @Nonnull String token) {
        return (InternalRememberMeToken)HibernateUtils.initialize((Object)((InternalRememberMeToken)this.session().createQuery("from InternalRememberMeToken where series = :series and token = :token").setString("series", series).setString("token", token).uniqueResult()));
    }

    @Override
    public InternalRememberMeToken getById(Long id) {
        return (InternalRememberMeToken)HibernateUtils.initialize(super.getById(id));
    }

    @Override
    @Nonnull
    public List<InternalRememberMeToken> getByIds(@Nonnull Collection<Long> ids) {
        return HibernateUtils.initializeList(super.getByIds(ids));
    }

    @Override
    public InternalRememberMeToken loadById(Long id) {
        return (InternalRememberMeToken)HibernateUtils.initialize(super.loadById(id));
    }

    @Override
    public void refresh(InternalRememberMeToken entity) {
        super.refresh(entity);
        HibernateUtils.initialize((Object)entity);
    }

    @Override
    public InternalRememberMeToken update(InternalRememberMeToken entity) {
        return (InternalRememberMeToken)HibernateUtils.initialize((Object)super.update(entity));
    }

    @Override
    protected Iterable<Order> getImplicitOrder() {
        return Collections.singleton(Order.asc((String)"id"));
    }
}

