/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.bitbucket.repository.RepositoryVisibility;
import com.atlassian.stash.internal.repository.RepositoryOrder;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class RepositorySearchCriteria {
    private final String name;
    private final String projectName;
    private final RepositoryOrder order;
    private final RepositoryVisibility visibility;

    private RepositorySearchCriteria(Builder builder) {
        this.name = builder.name;
        this.projectName = builder.projectName;
        this.order = builder.order;
        this.visibility = builder.visibility;
    }

    @Nonnull
    public RepositoryOrder getOrder() {
        return this.order;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getProjectName() {
        return this.projectName;
    }

    @Nullable
    public RepositoryVisibility getVisibility() {
        return this.visibility;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasProjectName() {
        return this.projectName != null;
    }

    public boolean hasVisibility() {
        return this.visibility != null;
    }

    public static class Builder {
        private String name;
        private String projectName;
        private RepositoryOrder order = RepositoryOrder.DEFAULT;
        private RepositoryVisibility visibility;

        @Nonnull
        public RepositorySearchCriteria build() {
            return new RepositorySearchCriteria(this);
        }

        @Nonnull
        public Builder name(@Nullable String value) {
            this.name = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Nonnull
        public Builder order(@Nonnull RepositoryOrder value) {
            this.order = (RepositoryOrder)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"order"));
            return this.self();
        }

        @Nonnull
        public Builder projectName(@Nonnull String value) {
            this.projectName = value;
            return this.self();
        }

        @Nonnull
        public Builder visibility(@Nullable RepositoryVisibility value) {
            this.visibility = value;
            return this.self();
        }

        private Builder self() {
            return this;
        }
    }
}

