/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.stash.internal.backup.DatabaseTableAttribute;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public enum DatabaseTable {
    APP_PROPERTY("app_property", new DatabaseTableAttribute[0]),
    CWD_APPLICATION("cwd_application", DatabaseTableAttribute.CROWD),
    CWD_DIRECTORY("cwd_directory", DatabaseTableAttribute.CROWD),
    CWD_APP_DIR_MAPPING("cwd_app_dir_mapping", DatabaseTableAttribute.CROWD),
    CWD_APP_DIR_GROUP_MAPPING("cwd_app_dir_group_mapping", DatabaseTableAttribute.CROWD),
    CWD_APP_DIR_OPERATION("cwd_app_dir_operation", DatabaseTableAttribute.CROWD),
    CWD_APPLICATION_ADDRESS("cwd_application_address", DatabaseTableAttribute.CROWD),
    CWD_APPLICATION_ALIAS("cwd_application_alias", DatabaseTableAttribute.CROWD),
    CWD_APPLICATION_ATTRIBUTE("cwd_application_attribute", DatabaseTableAttribute.CROWD),
    CWD_DIRECTORY_ATTRIBUTE("cwd_directory_attribute", DatabaseTableAttribute.CROWD),
    CWD_DIRECTORY_OPERATION("cwd_directory_operation", DatabaseTableAttribute.CROWD),
    CWD_GROUP("cwd_group", DatabaseTableAttribute.CROWD),
    CWD_GROUP_ATTRIBUTE("cwd_group_attribute", DatabaseTableAttribute.CROWD),
    CWD_MEMBERSHIP("cwd_membership", DatabaseTableAttribute.CROWD),
    CWD_PROPERTY("cwd_property", DatabaseTableAttribute.CROWD),
    CWD_USER("cwd_user", DatabaseTableAttribute.CROWD),
    CWD_USER_ATTRIBUTE("cwd_user_attribute", DatabaseTableAttribute.CROWD),
    CWD_USER_CREDENTIAL_RECORD("cwd_user_credential_record", DatabaseTableAttribute.CROWD),
    STASH_USER("stash_user", new DatabaseTableAttribute[0]),
    STA_NORMAL_USER("sta_normal_user", new DatabaseTableAttribute[0]),
    STA_SERVICE_USER("sta_service_user", new DatabaseTableAttribute[0]),
    STA_SHARED_LOB("sta_shared_lob", new DatabaseTableAttribute[0]),
    STA_USER_SETTINGS("sta_user_settings", new DatabaseTableAttribute[0]),
    PROJECT("project", new DatabaseTableAttribute[0]),
    STA_NORMAL_PROJECT("sta_normal_project", new DatabaseTableAttribute[0]),
    STA_PERSONAL_PROJECT("sta_personal_project", new DatabaseTableAttribute[0]),
    REPOSITORY("repository", new DatabaseTableAttribute[0]),
    STA_REPO_HOOK("sta_repo_hook", new DatabaseTableAttribute[0]),
    STA_PERMISSION_TYPE("sta_permission_type", "perm_id", DatabaseTableAttribute.PREPOPULATED),
    STA_GLOBAL_PERMISSION("sta_global_permission", new DatabaseTableAttribute[0]),
    STA_PROJECT_PERMISSION("sta_project_permission", new DatabaseTableAttribute[0]),
    STA_REPO_PERMISSION("sta_repo_permission", new DatabaseTableAttribute[0]),
    TRUSTED_APP("trusted_app", new DatabaseTableAttribute[0]),
    TRUSTED_APP_RESTRICTION("trusted_app_restriction", new DatabaseTableAttribute[0]),
    CURRENT_APP("current_app", new DatabaseTableAttribute[0]),
    STA_REMEMBER_ME_TOKEN("sta_remember_me_token", new DatabaseTableAttribute[0]),
    HIBERNATE_UNIQUE_KEY("hibernate_unique_key", DatabaseTableAttribute.PREPOPULATED),
    ID_SEQUENCE("id_sequence", new DatabaseTableAttribute[0]),
    PLUGIN_SETTING("plugin_setting", new DatabaseTableAttribute[0]),
    PLUGIN_STATE("plugin_state", new DatabaseTableAttribute[0]),
    CHANGESET("changeset", new DatabaseTableAttribute[0]),
    CS_ATTRIBUTE("cs_attribute", new DatabaseTableAttribute[0]),
    CS_REPO_MEMBERSHIP("cs_repo_membership", new DatabaseTableAttribute[0]),
    CS_INDEXER_STATE("cs_indexer_state", new DatabaseTableAttribute[0]),
    REPOSITORY_ACCESS("repository_access", new DatabaseTableAttribute[0]),
    STA_REPOSITORY_SCOPED_ID("sta_repository_scoped_id", new DatabaseTableAttribute[0]),
    STA_TASK("sta_task", new DatabaseTableAttribute[0]),
    STA_COMMENT("sta_comment", "id", new DatabaseTableAttribute[0]),
    STA_DIFF_COMMENT_ANCHOR("sta_diff_comment_anchor", new DatabaseTableAttribute[0]),
    STA_COMMIT_DISCUSSION("sta_cmt_discussion", new DatabaseTableAttribute[0]),
    STA_CMT_DISC_COMMENT_ANCHOR("sta_cmt_disc_comment_anchor", new DatabaseTableAttribute[0]),
    STA_CMT_DISC_PARTICIPANT("sta_cmt_disc_participant", new DatabaseTableAttribute[0]),
    BB_PR_PART_STATUS_WEIGHT("bb_pr_part_status_weight", DatabaseTableAttribute.PREPOPULATED),
    STA_PULL_REQUEST("sta_pull_request", new DatabaseTableAttribute[0]),
    STA_PR_DIFF_COMMENT_ANCHOR("sta_pr_diff_comment_anchor", new DatabaseTableAttribute[0]),
    STA_PR_PARTICIPANT("sta_pr_participant", new DatabaseTableAttribute[0]),
    STA_DRIFT_REQUEST("sta_drift_request", new DatabaseTableAttribute[0]),
    STA_ACTIVITY("sta_activity", new DatabaseTableAttribute[0]),
    STA_REPO_ACTIVITY("sta_repo_activity", new DatabaseTableAttribute[0]),
    STA_REPO_ORIGIN("sta_repo_origin", new DatabaseTableAttribute[0]),
    STA_REPO_PUSH_ACTIVITY("sta_repo_push_activity", new DatabaseTableAttribute[0]),
    STA_REPO_PUSH_REF("sta_repo_push_ref", new DatabaseTableAttribute[0]),
    STA_CMT_DISC_ACTIVITY("sta_cmt_disc_activity", new DatabaseTableAttribute[0]),
    STA_CMT_DISC_COMMENT_ACTIVITY("sta_cmt_disc_comment_activity", new DatabaseTableAttribute[0]),
    STA_PR_ACTIVITY("sta_pr_activity", new DatabaseTableAttribute[0]),
    STA_PR_COMMENT_ACTIVITY("sta_pr_comment_activity", new DatabaseTableAttribute[0]),
    STA_PR_MERGE_ACTIVITY("sta_pr_merge_activity", new DatabaseTableAttribute[0]),
    STA_PR_RESCOPE_ACTIVITY("sta_pr_rescope_activity", new DatabaseTableAttribute[0]),
    STA_PR_RESCOPE_COMMITS("sta_pr_rescope_commit", new DatabaseTableAttribute[0]),
    STA_PR_RESCOPE_REQUEST("sta_pr_rescope_request", new DatabaseTableAttribute[0]),
    STA_PR_RESCOPE_REQUEST_CHANGE("sta_pr_rescope_request_change", new DatabaseTableAttribute[0]),
    BB_PR_REVIEWERS_UPDATED_ACTIVITY("bb_pr_reviewer_upd_activity", new DatabaseTableAttribute[0]),
    BB_PR_REVIEWERS_ADDED("bb_pr_reviewer_added", new DatabaseTableAttribute[0]),
    BB_PR_REVIEWERS_REMOVED("bb_pr_reviewer_removed", new DatabaseTableAttribute[0]),
    STA_WATCHER("sta_watcher", new DatabaseTableAttribute[0]),
    STA_DELETED_GROUP("sta_deleted_group", new DatabaseTableAttribute[0]);

    private static Map<String, DatabaseTable> NAME_TO_TABLE_MAP;
    private final String tableName;
    private final String orderingColumn;
    private final Set<DatabaseTableAttribute> attributes;

    private static Map<String, DatabaseTable> buildNameToTableMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DatabaseTable table : DatabaseTable.values()) {
            builder.put((Object)table.getTableName(), (Object)table);
        }
        return builder.build();
    }

    public static boolean isKnownTable(String tableName) {
        return NAME_TO_TABLE_MAP.containsKey(tableName);
    }

    private DatabaseTable(String tableName, DatabaseTableAttribute ... attributes) {
        this(tableName, (String)null, attributes);
    }

    private DatabaseTable(String tableName, String orderingColumn, DatabaseTableAttribute ... attributes) {
        this.tableName = tableName.toLowerCase(Locale.US);
        this.orderingColumn = orderingColumn;
        this.attributes = attributes.length > 0 ? EnumSet.copyOf(ImmutableSet.copyOf((Object[])attributes)) : Collections.emptySet();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getOrderingColumn() {
        return this.orderingColumn;
    }

    public static List<String> getTableNames() {
        return Chainable.chain(DatabaseTable.getTables()).transform(DatabaseTable::getTableName).toList();
    }

    public static List<String> getTableNames(DatabaseTableAttribute first, DatabaseTableAttribute ... rest) {
        return Chainable.chain(DatabaseTable.getTables()).filter(DatabaseTable.with(first, rest)).transform(DatabaseTable::getTableName).toList();
    }

    public static List<DatabaseTable> getTables() {
        return ImmutableList.copyOf((Object[])DatabaseTable.values());
    }

    private static Predicate<DatabaseTable> with(DatabaseTableAttribute first, DatabaseTableAttribute ... rest) {
        EnumSet<DatabaseTableAttribute[]> desired = EnumSet.of(first, rest);
        return input -> input.attributes.containsAll(desired);
    }

    static {
        NAME_TO_TABLE_MAP = DatabaseTable.buildNameToTableMap();
    }
}

