/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.audit;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.bitbucket.audit.AuditEventConverter;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.internal.codeinsights.event.InsightReportConditionAddedEvent;
import com.atlassian.bitbucket.internal.codeinsights.event.InsightReportConditionEvent;
import com.atlassian.bitbucket.internal.codeinsights.event.InsightReportConditionUpdatedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.AuditUtils;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nonnull;

public class InsightReportConditionEventConverter
implements AuditEventConverter<InsightReportConditionEvent> {
    @VisibleForTesting
    static final String ACTION_REPOSITORY_INSIGHT_ADDED = "bitbucket.codeinsights.audit.action.repositoryinsightreportconditionadded";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_INSIGHT_DELETED = "bitbucket.codeinsights.audit.action.repositoryinsightreportconditiondeleted";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_INSIGHT_UPDATED = "bitbucket.codeinsights.audit.action.repositoryinsightreportconditionupdated";
    @VisibleForTesting
    static final String ATTR_MIN_PROHIBITED_SEVERITY = "bitbucket.codeinsights.audit.attribute.insightreportcondition.minprohibitedseverity";
    @VisibleForTesting
    static final String ATTR_MUST_PASS = "bitbucket.codeinsights.audit.attribute.insightreportcondition.mustpass";
    @VisibleForTesting
    static final String ATTR_REPORT_KEY = "bitbucket.codeinsights.audit.attribute.insightreportcondition.reportkey";
    private static final String NO_SEVERITY = "NONE";

    @Nonnull
    public AuditEvent convert(final @Nonnull InsightReportConditionEvent event, final @Nonnull AuditEvent.Builder builder) {
        event.getScope().accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                builder.affectedObject(AuditUtils.auditResourceForProject((Project)scope.getProject()));
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                builder.actionI18nKey(InsightReportConditionEventConverter.toRepositoryActionI18nKey(event)).categoryI18nKey("bitbucket.service.audit.category.repositories").affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)scope.getRepository()));
                return null;
            }
        });
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_REPORT_KEY, (String)event.getReportKey()).build());
        if (event instanceof InsightReportConditionUpdatedEvent) {
            return InsightReportConditionEventConverter.addChangedValues((InsightReportConditionUpdatedEvent)event, builder).build();
        }
        return InsightReportConditionEventConverter.addExtraAttributes(event, builder).build();
    }

    private static AuditEvent.Builder addChangedValues(InsightReportConditionUpdatedEvent event, AuditEvent.Builder builder) {
        return builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_MUST_PASS).from(String.valueOf(event.isPreviousMustPass())).to(String.valueOf(event.isMustPass())).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_MIN_PROHIBITED_SEVERITY).from(InsightReportConditionEventConverter.severityToString(event.getPreviousMinimumProhibitedSeverity())).to(InsightReportConditionEventConverter.severityToString(event.getMinimumProhibitedSeverity())).build());
    }

    private static AuditEvent.Builder addExtraAttributes(InsightReportConditionEvent event, AuditEvent.Builder builder) {
        return builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_MUST_PASS, (String)String.valueOf(event.isMustPass())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_MIN_PROHIBITED_SEVERITY, (String)InsightReportConditionEventConverter.severityToString(event.getMinimumProhibitedSeverity())).build());
    }

    private static String severityToString(AnnotationSeverity severity) {
        return severity == null ? NO_SEVERITY : severity.toString();
    }

    private static String toRepositoryActionI18nKey(InsightReportConditionEvent event) {
        if (event instanceof InsightReportConditionAddedEvent) {
            return ACTION_REPOSITORY_INSIGHT_ADDED;
        }
        if (event instanceof InsightReportConditionUpdatedEvent) {
            return ACTION_REPOSITORY_INSIGHT_UPDATED;
        }
        return ACTION_REPOSITORY_INSIGHT_DELETED;
    }
}

