/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.codeinsights.annotation.AnnotationCallback;
import com.atlassian.bitbucket.codeinsights.annotation.InsightAnnotation;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightAnnotation;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.StatefulJsonWriter;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;

public abstract class AbstractInsightResource {
    protected static final String EXTERNAL_ID_KEY = "externalId";
    protected static final String EXTERNAL_ID_PATH = "{externalId}";
    protected static final String REPORTS = "reports";
    protected static final String REPORT_KEY = "key";
    protected static final int REPORT_KEY_LIMIT = 50;
    protected static final String REPORT_PATH = "{key}";
    protected static final String REPORT_URI = "reports/{key}";
    protected final I18nService i18nService;

    protected AbstractInsightResource(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    protected RestErrors noSuchReport(String key) {
        return new RestErrors.Builder().add(new RestErrorMessage("reportKey", this.i18nService.getMessage("bitbucket.rest.codeinsights.error.no.report", new Object[]{key}))).build();
    }

    protected URI toURI(String url, String message) {
        if (url == null) {
            return null;
        }
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage(message, new Object[0]));
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage(message, new Object[0]));
        }
    }

    protected static class RestAnnotationCallback
    implements AnnotationCallback {
        protected final StatefulJsonWriter writer;

        public RestAnnotationCallback(StatefulJsonWriter writer) {
            this.writer = writer;
        }

        @Override
        public boolean onAnnotation(@Nonnull InsightAnnotation annotation) {
            try {
                this.writer.value((Object)new RestInsightAnnotation(annotation));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to write response", e);
            }
            return true;
        }

        @Override
        public void onEnd(boolean truncated) {
            try {
                this.writer.endArray();
                this.beforeEndObject(truncated);
                this.writer.endObject();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to write response", e);
            }
        }

        @Override
        public void onStart(int totalAnnotationCount) {
            try {
                this.writer.beginObject();
                this.writer.name("totalCount").value((long)totalAnnotationCount);
                this.writer.name("annotations").beginArray();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to write response", e);
            }
        }

        protected void beforeEndObject(boolean truncated) throws IOException {
        }
    }
}

