/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.annotation;

import com.atlassian.bitbucket.internal.codeinsights.annotation.LineRange;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class FileChanges {
    private final Set<LineRange> lineRanges;
    private final boolean truncated;

    private FileChanges(Builder builder) {
        this.lineRanges = ImmutableSet.copyOf((Collection)builder.lineRanges);
        this.truncated = builder.truncated;
    }

    public Set<LineRange> getLineRanges() {
        return this.lineRanges;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public static class Builder {
        private final Set<LineRange> lineRanges = new HashSet<LineRange>();
        private boolean truncated;

        public Builder addLineRange(LineRange lineRange) {
            this.lineRanges.add(lineRange);
            return this;
        }

        public FileChanges build() {
            return new FileChanges(this);
        }

        public Builder truncated(boolean truncated) {
            this.truncated = truncated;
            return this;
        }
    }
}

