/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights.annotation;

import com.atlassian.bitbucket.codeinsights.AbstractInsightsBuilder;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationSeverity;
import com.atlassian.bitbucket.codeinsights.annotation.AnnotationType;
import com.atlassian.bitbucket.codeinsights.annotation.InsightAnnotation;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SingleAddInsightAnnotationRequest {
    private final String externalId;
    private final int line;
    private final URI link;
    private final String message;
    private final String path;
    private final AnnotationSeverity severity;
    private final AnnotationType type;

    private SingleAddInsightAnnotationRequest(Builder builder) {
        this.externalId = builder.externalId;
        this.line = builder.line;
        this.link = builder.link;
        this.message = builder.message;
        this.path = StringUtils.stripToEmpty((String)builder.path);
        this.severity = builder.severity;
        this.type = builder.type;
    }

    @Nullable
    public String getExternalId() {
        return this.externalId;
    }

    public int getLine() {
        return this.line;
    }

    @Nullable
    public URI getLink() {
        return this.link;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public AnnotationSeverity getSeverity() {
        return this.severity;
    }

    @Nullable
    public AnnotationType getType() {
        return this.type;
    }

    public static final class Builder
    extends AbstractInsightsBuilder {
        private static final int MAX_EXTERNAL_ID_LENGTH = 450;
        private static final int MAX_MESSAGE_LENGTH = 2000;
        private static final int MAX_PATH_LENGTH = 50000;
        private String externalId;
        private int line;
        private URI link;
        private String message;
        private String path;
        private AnnotationSeverity severity = AnnotationSeverity.LOW;
        private AnnotationType type;

        public Builder(int line, @Nonnull String message, @Nonnull String path) {
            this.line = this.validateLine(line);
            this.message = this.validateMessage(message);
            this.path = this.validatePath(path);
        }

        public Builder(@Nonnull String message) {
            this.message = this.validateMessage(message);
        }

        public Builder(@Nonnull InsightAnnotation annotation) {
            this.line = Objects.requireNonNull(annotation, "annotation").getLine();
            this.message = annotation.getMessage();
            this.path = annotation.getFilePath().orElse("");
            this.severity = annotation.getSeverity();
            annotation.getExternalId().ifPresent(externalId -> {
                this.externalId = externalId;
            });
            annotation.getLink().ifPresent(link -> {
                this.link = link;
            });
            annotation.getType().ifPresent(type -> {
                this.type = type;
            });
        }

        public SingleAddInsightAnnotationRequest build() {
            return new SingleAddInsightAnnotationRequest(this);
        }

        @Nonnull
        public Builder externalId(@Nullable String value) {
            if (value != null) {
                Preconditions.checkArgument((value.length() <= 450 ? 1 : 0) != 0, (Object)"The external id can not be more than 450 characters long");
            }
            this.externalId = value;
            return this;
        }

        @Nonnull
        public Builder line(int value) {
            this.line = this.validateLine(value);
            return this;
        }

        @Nonnull
        public Builder link(@Nullable URI value) {
            this.link = this.validate(value, "link");
            return this;
        }

        @Nonnull
        public Builder message(@Nonnull String value) {
            this.message = this.validateMessage(value);
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull String value) {
            this.path = this.validatePath(value);
            return this;
        }

        @Nonnull
        public Builder severity(@Nonnull AnnotationSeverity value) {
            this.severity = Objects.requireNonNull(value, "severity");
            return this;
        }

        @Nonnull
        public Builder type(@Nullable AnnotationType value) {
            this.type = value;
            return this;
        }

        private int validateLine(int line) {
            Preconditions.checkArgument((line >= 0 ? 1 : 0) != 0, (Object)String.format("The line number %d is invalid. Line number must be greater or equal to 0", line));
            return line;
        }

        private String validateMessage(@Nonnull String message) {
            Preconditions.checkArgument((Builder.requireNonBlank((String)message, (String)"message").length() <= 2000 ? 1 : 0) != 0, (Object)String.format("The message cannot be more than %s characters long", 2000));
            return message;
        }

        private String validatePath(@Nonnull String path) {
            Preconditions.checkArgument((Objects.requireNonNull(path, "path").length() <= 50000 ? 1 : 0) != 0, (Object)String.format("The path is too long. It cannot be more than %d characters long", 50000));
            return path;
        }
    }
}

