/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights.report;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DeleteInsightReportRequest {
    private final String commitId;
    private final String key;
    private final Repository repository;

    private DeleteInsightReportRequest(Builder builder) {
        this.commitId = builder.commitId;
        this.key = builder.key;
        this.repository = builder.repository;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static final class Builder
    extends BuilderSupport {
        private final String commitId;
        private final String key;
        private final Repository repository;

        public Builder(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull String key) {
            this.commitId = Builder.requireNonBlank((String)commitId, (String)"commit id");
            this.key = Builder.requireNonBlank((String)key, (String)"key");
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        @Nonnull
        public DeleteInsightReportRequest build() {
            return new DeleteInsightReportRequest(this);
        }
    }
}

