/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.settingsrestriction;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.settingsrestriction.SettingsKey;
import com.atlassian.bitbucket.settingsrestriction.UnsupportedPersonalProjectException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ProjectSettingsRestrictionCreateRequest {
    private final Project project;
    private final SettingsKey settingsKey;

    private ProjectSettingsRestrictionCreateRequest(Builder builder) {
        this.project = builder.project;
        this.settingsKey = builder.settingsKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectSettingsRestrictionCreateRequest that = (ProjectSettingsRestrictionCreateRequest)o;
        return this.project.equals(that.project) && this.settingsKey.equals(that.settingsKey);
    }

    @Nonnull
    public Project getProject() {
        return this.project;
    }

    @Nonnull
    public SettingsKey getSettingsKey() {
        return this.settingsKey;
    }

    public int hashCode() {
        return Objects.hash(this.project, this.settingsKey);
    }

    public static class Builder {
        private final Project project;
        private final SettingsKey settingsKey;

        public Builder(@Nonnull Project project, @Nonnull SettingsKey settingsKey) {
            this.project = Objects.requireNonNull(project, "project");
            this.settingsKey = Objects.requireNonNull(settingsKey, "settingsKey");
            if (project.getType() == ProjectType.PERSONAL) {
                throw new UnsupportedPersonalProjectException("Settings cannot be restricted on personal projects", project);
            }
        }

        @Nonnull
        public ProjectSettingsRestrictionCreateRequest build() {
            return new ProjectSettingsRestrictionCreateRequest(this);
        }
    }
}

