/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.filestore;

import com.atlassian.bitbucket.filestore.ChecksumAlgorithm;
import com.atlassian.bitbucket.filestore.FilePath;
import com.atlassian.bitbucket.util.BuilderSupport;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GeneratePutUrlRequest {
    private final String checksum;
    private final ChecksumAlgorithm checksumAlgorithm;
    private final Duration expiry;
    private final String namespace;
    private final FilePath path;

    private GeneratePutUrlRequest(@Nonnull Builder builder) {
        this.checksum = builder.checksum;
        this.checksumAlgorithm = builder.checksumAlgorithm;
        this.expiry = builder.expiry;
        this.path = builder.path;
        this.namespace = builder.namespace;
    }

    @Nullable
    public String getChecksum() {
        return this.checksum;
    }

    @Nullable
    public ChecksumAlgorithm getChecksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    @Nullable
    public Duration getExpiry() {
        return this.expiry;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @Nullable
    public FilePath getPath() {
        return this.path;
    }

    public static class Builder
    extends BuilderSupport {
        private String checksum;
        private ChecksumAlgorithm checksumAlgorithm;
        private Duration expiry;
        private String namespace;
        private FilePath path;

        public GeneratePutUrlRequest build() {
            return new GeneratePutUrlRequest(this);
        }

        @Nonnull
        public Builder checksumSHA256(@Nonnull String value) {
            this.checksum = Objects.requireNonNull(value, "checksumSHA256");
            this.checksumAlgorithm = ChecksumAlgorithm.SHA256;
            return this;
        }

        @Nonnull
        public Builder expiry(@Nullable Duration value) {
            this.expiry = value;
            return this;
        }

        @Nonnull
        public Builder namespace(@Nonnull String value) {
            this.namespace = Builder.requireNonBlank(value, "namespace");
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull FilePath value) {
            this.path = Objects.requireNonNull(value, "path");
            return this;
        }
    }
}

