/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.filestore;

import javax.annotation.Nonnull;

public enum ChecksumAlgorithm {
    SHA256("SHA256");

    private final String algorithm;

    private ChecksumAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String toString() {
        return String.valueOf(this.algorithm);
    }

    @Nonnull
    public static ChecksumAlgorithm fromValue(String value) {
        for (ChecksumAlgorithm b : ChecksumAlgorithm.values()) {
            if (!b.algorithm.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

