/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractMergeCommandParameters;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class MergeCommandParameters
extends AbstractMergeCommandParameters {
    private final String fromBranch;
    private final String fromCommitId;
    private final Repository fromRepository;
    private final String toBranch;
    private final String toCommitId;

    protected MergeCommandParameters(AbstractMergeBuilder builder) {
        super(builder);
        this.fromBranch = builder.fromBranch;
        this.fromCommitId = builder.fromCommitId;
        this.fromRepository = builder.fromRepository;
        this.toBranch = builder.toBranch;
        this.toCommitId = builder.toCommitId;
    }

    @Nonnull
    public String getFromBranch() {
        return this.fromBranch;
    }

    @Nullable
    public String getFromCommitId() {
        return this.fromCommitId;
    }

    @Nullable
    public Repository getFromRepository() {
        return this.fromRepository;
    }

    @Nonnull
    public String getToBranch() {
        return this.toBranch;
    }

    @Nullable
    public String getToCommitId() {
        return this.toCommitId;
    }

    public boolean hasFromRepository() {
        return this.fromRepository != null;
    }

    public static abstract class AbstractMergeBuilder<B extends AbstractMergeBuilder<B>>
    extends AbstractMergeCommandParameters.AbstractBuilder<B> {
        private String fromBranch;
        private String fromCommitId;
        private Repository fromRepository;
        private String toBranch;
        private String toCommitId;

        @Nonnull
        public B fromBranch(String value) {
            this.fromBranch = MergeCommandParameters.checkNotBlank(value, "fromBranch");
            return (B)((AbstractMergeBuilder)this.self());
        }

        @Nonnull
        public B fromCommitId(@Nullable String value) {
            this.fromCommitId = value;
            return (B)((AbstractMergeBuilder)this.self());
        }

        @Nonnull
        public B fromRepository(@Nullable Repository value) {
            this.fromRepository = value;
            return (B)((AbstractMergeBuilder)this.self());
        }

        @Nonnull
        public B toBranch(String value) {
            this.toBranch = MergeCommandParameters.checkNotBlank(value, "toBranch");
            return (B)((AbstractMergeBuilder)this.self());
        }

        @Nonnull
        public B toCommitId(@Nullable String value) {
            this.toCommitId = value;
            return (B)((AbstractMergeBuilder)this.self());
        }

        @Override
        protected void validate() {
            super.validate();
            if (StringUtils.isBlank((CharSequence)this.fromBranch)) {
                throw new IllegalStateException("When performing a merge, the name of the branch to merge from is required");
            }
            if (StringUtils.isBlank((CharSequence)this.toBranch)) {
                throw new IllegalStateException("When performing a merge, the name of the branch to merge into is required");
            }
        }
    }

    public static class Builder
    extends AbstractMergeBuilder<Builder> {
        @Nonnull
        public MergeCommandParameters build() {
            this.validate();
            return new MergeCommandParameters(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

