/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResolveRefCommandParameters
extends AbstractCommandParameters {
    private final String refId;
    private final RefType type;

    private ResolveRefCommandParameters(Builder builder) {
        this.refId = builder.refId;
        this.type = builder.type;
    }

    @Nonnull
    public String getRefId() {
        return this.refId;
    }

    @Nonnull
    public Optional<RefType> getType() {
        return Optional.ofNullable(this.type);
    }

    public static class Builder {
        private final String refId;
        private RefType type;

        public Builder(@Nonnull String refId) {
            this.refId = Objects.requireNonNull(refId, "refId");
        }

        @Nonnull
        public ResolveRefCommandParameters build() {
            return new ResolveRefCommandParameters(this);
        }

        @Nonnull
        public Builder type(@Nullable RefType value) {
            this.type = value;
            return this;
        }
    }
}

