/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.label.Labelable;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.bitbucket.watcher.Watchable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Repository
extends Labelable,
Watchable {
    public static final int MAX_DESCRIPTION_LENGTH = 255;
    public static final int MAX_NAME_LENGTH = 128;
    public static final String NAME_REGEXP = "[\\p{Alnum}][\\w\\-\\. ]*";
    public static final int SLUG_MAX_SIZE = 128;
    public static final String SLUG_REGEXP = "[\\p{Alnum}][\\w\\-\\.]*";

    @Nullable
    @OptionalString(size=255, message="{com.atlassian.bitbucket.validation.repository.description.message}")
    public String getDescription();

    @Nonnull
    public String getHierarchyId();

    public int getId();

    @Nonnull
    @RequiredString(size=128, regexp="[\\p{Alnum}][\\w\\-\\. ]*", message="{com.atlassian.bitbucket.validation.repository.name.pattern.message}")
    public String getName();

    @Nullable
    public Repository getOrigin();

    @Nonnull
    public Project getProject();

    @Nonnull
    @RequiredString
    public String getScmId();

    @Nonnull
    @RequiredString(size=128, regexp="[\\p{Alnum}][\\w\\-\\.]*")
    public String getSlug();

    @Nonnull
    public State getState();

    @Nonnull
    public String getStatusMessage();

    public boolean isFork();

    public boolean isArchived();

    public boolean isForkable();

    public boolean isLocal();

    public boolean isOffline();

    public boolean isPublic();

    public boolean isReadOnly();

    public boolean isRemote();

    public static enum State {
        AVAILABLE(1, "Available"),
        INITIALISATION_FAILED(2, "Failed to initialise repository"),
        INITIALISING(0, "Initialising"),
        OFFLINE(3, "Offline");

        private final int id;
        private final String statusMessage;

        private State(int id, String statusMessage) {
            this.id = id;
            this.statusMessage = Objects.requireNonNull(statusMessage, "statusMessage");
        }

        public int getId() {
            return this.id;
        }

        @Nonnull
        public String getStatusMessage() {
            return this.statusMessage;
        }

        public static State fromId(int id) {
            for (State value : State.values()) {
                if (value.getId() != id) continue;
                return value;
            }
            throw new IllegalArgumentException("No Repository.State is associated with ID [" + id + "]");
        }
    }
}

