/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.hook.repository.RepositoryHookType;
import com.atlassian.bitbucket.scope.Scope;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class RepositoryHookSearchRequest {
    private final Scope scope;
    private final RepositoryHookType type;

    private RepositoryHookSearchRequest(Builder builder) {
        this.scope = builder.scope;
        this.type = builder.type;
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    @Nonnull
    public Optional<RepositoryHookType> getType() {
        return Optional.ofNullable(this.type);
    }

    public static class Builder {
        private Scope scope;
        private RepositoryHookType type;

        public Builder(@Nonnull Scope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
        }

        @Nonnull
        public RepositoryHookSearchRequest build() {
            return new RepositoryHookSearchRequest(this);
        }

        @Nonnull
        public Builder type(@Nonnull RepositoryHookType value) {
            this.type = Objects.requireNonNull(value, "type");
            return this;
        }
    }
}

